/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.store.hbase.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class HBasePersistenceHandler
extends AbstractPersistenceHandler {
    public HBasePersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.insertObject(ops[0]);
            return;
        }
        super.insertObjects(ops);
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        if (!this.storeMgr.managesClass(op.getClassMetaData().getFullClassName())) {
            this.storeMgr.manageClasses(op.getExecutionContext().getClassLoaderResolver(), new String[]{op.getClassMetaData().getFullClassName()});
        }
        ExecutionContext ec = op.getExecutionContext();
        AbstractClassMetaData cmd = op.getClassMetaData();
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(ec);
        try {
            VersionMetaData vermd;
            String qualifName;
            String familyName;
            String colName;
            String qualifName2;
            String familyName2;
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HTableInterface table = mconn.getHTable(tableName);
            boolean enforceUniquenessInApp = this.storeMgr.getBooleanProperty("datanucleus.hbase.enforceUniquenessInApplication", false);
            if (enforceUniquenessInApp) {
                NucleusLogger.DATASTORE_PERSIST.info((Object)"User requesting to enforce uniqueness of object identity in their application, so not checking for existence");
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
                try {
                    if (HBaseUtils.objectExistsInTable(op, table)) {
                        throw new NucleusUserException(Localiser.msg((String)"HBase.Insert.ObjectWithIdAlreadyExists", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
                    }
                }
                catch (IOException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.Insert.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            Put put = HBaseUtils.getPutForObject(op);
            Delete delete = HBaseUtils.getDeleteForObject(op);
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                String colName2 = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
                familyName2 = HBaseUtils.getFamilyNameForColumnName(colName2, tableName);
                qualifName2 = HBaseUtils.getQualifierNameForColumnName(colName2);
                Object key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId());
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(key);
                    oos.flush();
                    put.add(familyName2.getBytes(), qualifName2.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            if (cmd.hasDiscriminatorStrategy()) {
                DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
                String discVal = null;
                discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
                colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
                familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                qualifName = HBaseUtils.getQualifierNameForColumnName(colName);
                put.add(familyName.getBytes(), qualifName.getBytes(), discVal.getBytes());
            }
            if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                String name = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
                familyName2 = HBaseUtils.getFamilyNameForColumnName(name, tableName);
                qualifName2 = HBaseUtils.getQualifierNameForColumnName(name);
                put.add(familyName2.getBytes(), qualifName2.getBytes(), this.storeMgr.getStringProperty("datanucleus.TenantID").getBytes());
            }
            if ((vermd = cmd.getVersionMetaDataForClass()) != null) {
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), null);
                op.setTransactionalVersion(nextVersion);
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"HBase.Insert.ObjectPersistedWithVersion", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), "" + nextVersion}));
                }
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    Number verFieldValue = (Long)nextVersion;
                    if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                        verFieldValue = ((Long)nextVersion).intValue();
                    }
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                } else {
                    colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                    familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                    qualifName = HBaseUtils.getQualifierNameForColumnName(colName);
                    if (nextVersion instanceof Long) {
                        put.add(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((long)((Long)nextVersion)));
                    } else if (nextVersion instanceof Integer) {
                        put.add(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((int)((Integer)nextVersion)));
                    } else {
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(bos);
                            oos.writeObject(nextVersion);
                            put.add(familyName.getBytes(), qualifName.getBytes(), bos.toByteArray());
                            oos.close();
                            bos.close();
                        }
                        catch (IOException e) {
                            throw new NucleusException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            StoreFieldManager fm = new StoreFieldManager(op, put, delete, true, tableName);
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)fm);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"HBase.Put", (Object[])new Object[]{StringUtils.toJVMIDString((Object)op.getObject()), tableName, put}));
            }
            table.put(put);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on insert", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.Update.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), fieldStr.toString()}));
            }
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HTableInterface table = mconn.getHTable(tableName);
            if (cmd.isVersioned()) {
                Result result = HBaseUtils.getResultForObject(op, table);
                Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result, ec, tableName, this.storeMgr);
                VersionHelper.performVersionCheck((ObjectProvider)op, (Object)datastoreVersion, (VersionMetaData)cmd.getVersionMetaDataForClass());
            }
            int[] updatedFieldNums = fieldNumbers;
            Put put = HBaseUtils.getPutForObject(op);
            Delete delete = HBaseUtils.getDeleteForObject(op);
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null) {
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), (Object)op.getTransactionalVersion());
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (!updatingVerField) {
                        updatedFieldNums = new int[fieldNumbers.length + 1];
                        System.arraycopy(fieldNumbers, 0, updatedFieldNums, 0, fieldNumbers.length);
                        updatedFieldNums[fieldNumbers.length] = verMmd.getAbsoluteFieldNumber();
                    }
                } else {
                    String colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                    String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                    String qualifName = HBaseUtils.getQualifierNameForColumnName(colName);
                    if (nextVersion instanceof Long) {
                        put.add(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((long)((Long)nextVersion)));
                    } else if (nextVersion instanceof Integer) {
                        put.add(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((int)((Integer)nextVersion)));
                    } else {
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(bos);
                            oos.writeObject(nextVersion);
                            put.add(familyName.getBytes(), qualifName.getBytes(), bos.toByteArray());
                            oos.close();
                            bos.close();
                        }
                        catch (IOException e) {
                            throw new NucleusException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            StoreFieldManager fm = new StoreFieldManager(op, put, delete, false, tableName);
            op.provideFields(updatedFieldNums, (FieldManager)fm);
            if (!put.isEmpty()) {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"HBase.Put", (Object[])new Object[]{StringUtils.toJVMIDString((Object)op.getObject()), tableName, put}));
                }
                table.put(put);
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumWrites();
                }
            }
            if (!delete.isEmpty()) {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"HBase.Delete", (Object[])new Object[]{StringUtils.toJVMIDString((Object)op.getObject()), tableName, delete}));
                }
                table.delete(delete);
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumWrites();
                }
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on update", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.deleteObject(ops[0]);
            return;
        }
        HashMap<String, HashSet<ObjectProvider>> opsByTable = new HashMap<String, HashSet<ObjectProvider>>();
        for (int i = 0; i < ops.length; ++i) {
            AbstractClassMetaData cmd = ops[i].getClassMetaData();
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HashSet<ObjectProvider> opsForTable = (HashSet<ObjectProvider>)opsByTable.get(tableName);
            if (opsForTable == null) {
                opsForTable = new HashSet<ObjectProvider>();
                opsByTable.put(tableName, opsForTable);
            }
            opsForTable.add(ops[i]);
        }
        HashSet<NucleusOptimisticException> optimisticExcps = null;
        for (Map.Entry entry : opsByTable.entrySet()) {
            String tableName = (String)entry.getKey();
            Set opsForTable = (Set)entry.getValue();
            ExecutionContext ec = ops[0].getExecutionContext();
            HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(ec);
            try {
                long startTime = System.currentTimeMillis();
                HTableInterface table = mconn.getHTable(tableName);
                ArrayList<Delete> deletes = new ArrayList<Delete>(opsForTable.size());
                for (ObjectProvider op : opsForTable) {
                    this.assertReadOnlyForUpdateOfObject(op);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.Delete.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
                    }
                    boolean deletable = true;
                    AbstractClassMetaData cmd = op.getClassMetaData();
                    if (cmd.isVersioned()) {
                        Object currentVersion = op.getTransactionalVersion();
                        Result result = HBaseUtils.getResultForObject(op, table);
                        Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result, ec, tableName, this.storeMgr);
                        if (!datastoreVersion.equals(currentVersion)) {
                            if (optimisticExcps == null) {
                                optimisticExcps = new HashSet<NucleusOptimisticException>();
                            }
                            optimisticExcps.add(new NucleusOptimisticException("Cannot delete object with id " + op.getInternalObjectId() + " since has version=" + currentVersion + " while datastore has version=" + datastoreVersion));
                            deletable = false;
                        }
                    }
                    if (!deletable) continue;
                    op.loadUnloadedFields();
                    op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op));
                    deletes.add(HBaseUtils.getDeleteForObject(op));
                }
                table.delete(deletes);
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumWrites();
                    for (int i = 0; i < opsForTable.size(); ++i) {
                        ec.getStatistics().incrementDeleteCount();
                    }
                }
                if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            catch (NucleusException ne) {
                throw ne;
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on delete", (Throwable)e);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
        if (optimisticExcps != null) {
            if (optimisticExcps.size() == 1) {
                throw (NucleusOptimisticException)optimisticExcps.iterator().next();
            }
            throw new NucleusOptimisticException("Optimistic exceptions thrown during delete of objects", (Throwable[])optimisticExcps.toArray(new NucleusOptimisticException[optimisticExcps.size()]));
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(ec);
        try {
            AbstractClassMetaData cmd = op.getClassMetaData();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.Delete.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HTableInterface table = mconn.getHTable(tableName);
            if (cmd.isVersioned()) {
                Result result = HBaseUtils.getResultForObject(op, table);
                Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result, ec, tableName, this.storeMgr);
                VersionHelper.performVersionCheck((ObjectProvider)op, (Object)datastoreVersion, (VersionMetaData)cmd.getVersionMetaDataForClass());
            }
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op));
            Delete delete = HBaseUtils.getDeleteForObject(op);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"HBase.Delete", (Object[])new Object[]{StringUtils.toJVMIDString((Object)op.getObject()), tableName, delete}));
            }
            table.delete(delete);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"HBase.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on delete", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        ExecutionContext ec = op.getExecutionContext();
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(ec);
        try {
            String tableName;
            HTableInterface table;
            Result result;
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer("Fetching object \"");
                str.append(op.getObjectAsPrintable()).append("\" (id=");
                str.append(op.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.PERSISTENCE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"HBase.Fetch.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if ((result = HBaseUtils.getResultForObject(op, table = mconn.getHTable(tableName = this.storeMgr.getNamingFactory().getTableName(cmd)))).getRow() == null) {
                throw new NucleusObjectNotFoundException();
            }
            if (cmd.hasDiscriminatorStrategy()) {
                String colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
                String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                String columnName = HBaseUtils.getQualifierNameForColumnName(colName);
                String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
                if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            FetchFieldManager fm = new FetchFieldManager(op, result, tableName);
            op.replaceFields(cmd.getAllMemberPositions(), (FieldManager)fm);
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null && op.getTransactionalVersion() == null) {
                if (vermd.getFieldName() != null) {
                    Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                    op.setVersion(datastoreVersion);
                } else {
                    op.setVersion(HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, this.storeMgr));
                }
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"HBase.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementFetchCount();
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on fetch", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ectx, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider op) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(op.getExecutionContext());
        try {
            AbstractClassMetaData cmd = op.getClassMetaData();
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HTableInterface table = mconn.getHTable(tableName);
            if (!HBaseUtils.objectExistsInTable(op, table)) {
                throw new NucleusObjectNotFoundException();
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on existence check", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void locateObjects(ObjectProvider[] ops) {
        super.locateObjects(ops);
    }
}

