/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBaseSchemaHandler
extends AbstractStoreSchemaHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());

    public HBaseSchemaHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        if (this.isAutoCreateTables() || this.isAutoCreateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                HBaseUtils.createSchemaForClass((HBaseStoreManager)this.storeMgr, cmd, false);
            }
        }
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Iterator<String> classIter = classNames.iterator();
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        while (classIter.hasNext()) {
            String className = classIter.next();
            AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd == null) continue;
            this.deleteSchemaForClass(cmd);
        }
    }

    void deleteSchemaForClass(final AbstractClassMetaData acmd) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        HBaseStoreManager hbaseStoreMgr = (HBaseStoreManager)this.storeMgr;
        final String tableName = this.storeMgr.getNamingFactory().getTableName(acmd);
        final Configuration config = hbaseStoreMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                    }
                    catch (TableNotFoundException ex) {
                        hTable = new HTableDescriptor(tableName);
                        hBaseAdmin.createTable(hTable);
                    }
                    return hTable;
                }
            });
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaDelete.Class", (Object)acmd.getFullClassName(), (Object)hTable.getNameAsString()));
                    hBaseAdmin.disableTable(hTable.getName());
                    hBaseAdmin.deleteTable(hTable.getName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        if (this.isValidateTables() || this.isValidateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                HBaseUtils.createSchemaForClass((HBaseStoreManager)this.storeMgr, cmd, true);
            }
        }
    }
}

