/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;

public class HBaseManagedConnection
extends AbstractManagedConnection {
    private HTablePool tablePool;
    private Map<String, HTableInterface> tables;
    private int idleTimeoutMills = 30000;
    private long expirationTime;
    private boolean isDisposed = false;

    public HBaseManagedConnection(HTablePool pool) {
        this.tablePool = pool;
        this.tables = new HashMap<String, HTableInterface>();
        this.disableExpirationTime();
    }

    public Object getConnection() {
        throw new NucleusDataStoreException("Unsupported Exception #getConnection() for " + ((Object)((Object)this)).getClass().getName());
    }

    public HTableInterface getHTable(String tableName) {
        HTableInterface table = this.tables.get(tableName);
        if (table == null) {
            try {
                table = this.tablePool.getTable(tableName);
                this.tables.put(tableName, table);
            }
            catch (RuntimeException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        return table;
    }

    public XAResource getXAResource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        if (this.tables.size() == 0) {
            return;
        }
        for (ManagedConnectionResourceListener listener : this.listeners) {
            listener.managedConnectionPreClose();
        }
        try {
            Map<String, HTableInterface> oldtables = this.tables;
            this.tables = new HashMap<String, HTableInterface>();
            for (String tableName : oldtables.keySet()) {
                try {
                    HTableInterface table = oldtables.get(tableName);
                    table.close();
                }
                catch (IOException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    return;
                }
            }
        }
        finally {
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionPostClose();
            }
        }
    }

    protected void incrementUseCount() {
        super.incrementUseCount();
        this.disableExpirationTime();
    }

    public void release() {
        super.release();
        if (this.useCount == 0) {
            this.enableExpirationTime();
        }
    }

    private void enableExpirationTime() {
        this.expirationTime = System.currentTimeMillis() + (long)this.idleTimeoutMills;
    }

    private void disableExpirationTime() {
        this.expirationTime = -1L;
    }

    public void setIdleTimeoutMills(int mills) {
        this.idleTimeoutMills = mills;
    }

    public boolean isExpired() {
        return this.expirationTime > 0L && this.expirationTime > System.currentTimeMillis();
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

