/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseMetaDataListener;
import org.datanucleus.store.hbase.HBasePersistenceHandler;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBaseStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    MetaDataListener metadataListener;
    private Configuration hbaseConfig;

    public HBaseStoreManager(ClassLoaderResolver clr, NucleusContext ctx, Map<String, Object> props) {
        super("hbase", clr, ctx, props);
        this.persistenceHandler = new HBasePersistenceHandler((StoreManager)this);
        this.metadataListener = new HBaseMetaDataListener(this);
        MetaDataManager mmgr = this.nucleusContext.getMetaDataManager();
        mmgr.registerListener(this.metadataListener);
        Collection classNamesLoaded = mmgr.getClassesWithMetaData();
        if (classNamesLoaded != null && classNamesLoaded.size() > 0) {
            Iterator iter = classNamesLoaded.iterator();
            while (iter.hasNext()) {
                AbstractClassMetaData cmd = mmgr.getMetaDataForClass((String)iter.next(), clr);
                this.metadataListener.loaded(cmd);
            }
        }
        this.initialiseAutoStart(clr);
        this.logConfiguration();
    }

    protected void registerConnectionMgr() {
        super.registerConnectionMgr();
        this.connectionMgr.disableConnectionPool();
    }

    public void close() {
        this.nucleusContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public NucleusConnection getNucleusConnection(ExecutionContext om) {
        throw new UnsupportedOperationException();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("DatastoreIdentity");
        set.add("NonDurableIdentity");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        return set;
    }

    public Configuration getHbaseConfig() {
        if (this.hbaseConfig == null) {
            this.hbaseConfig = HBaseConfiguration.create();
        }
        return this.hbaseConfig;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        return super.getClassNameForObjectID(id, clr, ec);
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                this.registerStoreData(this.newStoreData(cmd, clr));
            }
            if (!this.isAutoCreateTables() && !this.isAutoCreateColumns()) continue;
            HBaseUtils.createSchemaForClass(this, (AbstractClassMetaData)cmd, false);
        }
    }

    protected Properties getPropertiesForGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ExecutionContext ec, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        Properties props = super.getPropertiesForGenerator(cmd, absoluteFieldNumber, ec, seqmd, tablegenmd);
        IdentityStrategy strategy = null;
        if (absoluteFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            strategy = mmd.getValueStrategy();
        } else {
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            strategy = idmd.getValueStrategy();
        }
        String tableName = this.getNamingFactory().getTableName(cmd);
        props.setProperty("table-name", tableName);
        if (strategy == IdentityStrategy.INCREMENT && tablegenmd != null) {
            props.remove("table-name");
        }
        return props;
    }

    public void createSchema(Set<String> classNames, Properties props) {
        if (this.isAutoCreateTables() || this.isAutoCreateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                HBaseUtils.createSchemaForClass(this, cmd, false);
            }
        }
    }

    public void deleteSchema(Set<String> classNames, Properties props) {
        Iterator<String> classIter = classNames.iterator();
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
        while (classIter.hasNext()) {
            String className = classIter.next();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd == null) continue;
            HBaseUtils.deleteSchemaForClass(this, cmd);
        }
    }

    public void validateSchema(Set<String> classNames, Properties props) {
        if (this.isValidateTables() || this.isValidateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                HBaseUtils.createSchemaForClass(this, cmd, true);
            }
        }
    }
}

