/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBaseUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());

    public static String getDefaultValueForMember(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length < 1) {
            return null;
        }
        return colmds[0].getDefaultValue();
    }

    public static String getFamilyNameForColumnName(String colName, String tableName) {
        if (colName != null && colName.indexOf(":") > 0) {
            return colName.substring(0, colName.indexOf(":"));
        }
        return tableName;
    }

    public static String getQualifierNameForColumnName(String colName) {
        if (colName != null && colName.indexOf(":") > 0) {
            return colName.substring(colName.indexOf(":") + 1);
        }
        return colName;
    }

    public static String getFamilyName(AbstractMemberMetaData mmd, int fieldNumber, String tableName) {
        AbstractMemberMetaData[] embmmds;
        ColumnMetaData[] colmds;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null && (colmds = (embMmd = (embmmds = embmd.getMemberMetaData())[fieldNumber]).getColumnMetaData()) != null && colmds.length > 0) {
            return HBaseUtils.getFamilyNameForColumnName(colmds[0].getName(), tableName);
        }
        return tableName;
    }

    public static String getQualifierName(AbstractMemberMetaData mmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        return HBaseUtils.getQualifierNameForColumnName(columnName);
    }

    public static String getFamilyName(AbstractClassMetaData acmd, int absoluteFieldNumber, String tableName) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return tableName;
    }

    public static String getQualifierName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = ammd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    static void createSchemaForClass(final HBaseStoreManager storeMgr, final AbstractClassMetaData acmd, final boolean validateOnly) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final String tableName = storeMgr.getNamingFactory().getTableName(acmd);
        final Configuration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    block3: {
                        hTable = null;
                        try {
                            hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                        }
                        catch (TableNotFoundException ex) {
                            if (validateOnly) {
                                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                                hTable = null;
                            }
                            if (!storeMgr.isAutoCreateTables()) break block3;
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                            hTable = new HTableDescriptor(tableName);
                            hBaseAdmin.createTable(hTable);
                        }
                    }
                    return hTable;
                }
            });
            if (hTable != null) {
                boolean modified = false;
                if (!hTable.hasFamily(tableName.getBytes())) {
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)tableName));
                    } else if (storeMgr.isAutoCreateColumns()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)tableName));
                        HColumnDescriptor hColumn = new HColumnDescriptor(tableName);
                        hTable.addFamily(hColumn);
                        modified = true;
                    }
                }
                int[] fieldNumbers = acmd.getAllMemberPositions();
                ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    int relationType = mmd.getRelationType(clr);
                    if ((relationType == 1 || relationType == 2) && mmd.isEmbedded()) {
                        HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, mmd, clr, validateOnly);
                        continue;
                    }
                    String familyName = HBaseUtils.getFamilyName(acmd, fieldNumbers[i], tableName);
                    if (hTable.hasFamily(familyName.getBytes())) continue;
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                        continue;
                    }
                    if (!storeMgr.isAutoCreateColumns()) continue;
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
                    HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                    hTable.addFamily(hColumn);
                    modified = true;
                }
                if (modified) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            hBaseAdmin.disableTable(hTable.getName());
                            hBaseAdmin.modifyTable(hTable.getName(), hTable);
                            hBaseAdmin.enableTable(hTable.getName());
                            return null;
                        }
                    });
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    static boolean createSchemaForEmbeddedMember(HBaseStoreManager storeMgr, HTableDescriptor hTable, AbstractMemberMetaData mmd, ClassLoaderResolver clr, boolean validateOnly) {
        boolean modified = false;
        String tableName = hTable.getNameAsString();
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int j = 0; j < embmmds.length; ++j) {
            AbstractMemberMetaData embMmd = embmmds[j];
            int embRelationType = embMmd.getRelationType(clr);
            if ((embRelationType == 1 || embRelationType == 2) && embMmd.isEmbedded()) {
                return HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, embMmd, clr, validateOnly);
            }
            String familyName = HBaseUtils.getFamilyName(embMmd, j, tableName);
            if (hTable.hasFamily(familyName.getBytes())) continue;
            if (validateOnly) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                continue;
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
            HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
            hTable.addFamily(hColumn);
            modified = true;
        }
        return modified;
    }

    static void deleteSchemaForClass(HBaseStoreManager storeMgr, final AbstractClassMetaData acmd) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final String tableName = storeMgr.getNamingFactory().getTableName(acmd);
        final Configuration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                    }
                    catch (TableNotFoundException ex) {
                        hTable = new HTableDescriptor(tableName);
                        hBaseAdmin.createTable(hTable);
                    }
                    return hTable;
                }
            });
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaDelete.Class", (Object)acmd.getFullClassName(), (Object)hTable.getNameAsString()));
                    hBaseAdmin.disableTable(hTable.getName());
                    hBaseAdmin.deleteTable(hTable.getName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    public static Object getVersionForObject(AbstractClassMetaData cmd, Result result, ExecutionContext ec, String tableName, StoreManager storeMgr) {
        if (cmd.isVersioned()) {
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                String familyName = HBaseUtils.getFamilyName(cmd, verMmd.getAbsoluteFieldNumber(), tableName);
                String qualifName = HBaseUtils.getQualifierName(cmd, verMmd.getAbsoluteFieldNumber());
                Object version = null;
                try {
                    byte[] bytes = result.getValue(familyName.getBytes(), qualifName.getBytes());
                    if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                        version = verMmd.getType() == Integer.class || verMmd.getType() == Integer.TYPE ? (Number)Bytes.toInt((byte[])bytes) : (Number)Bytes.toLong((byte[])bytes);
                    } else if (Date.class.isAssignableFrom(verMmd.getType())) {
                        String strValue = new String(bytes);
                        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(verMmd.getType(), String.class);
                        version = strConv.toMemberType((Object)strValue);
                        version = new Timestamp(((Date)version).getTime());
                    } else {
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream ois = new ObjectInputStream(bis);
                        version = ois.readObject();
                        ois.close();
                        bis.close();
                    }
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                return version;
            }
            return HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
        }
        return null;
    }

    public static Object getSurrogateVersionForObject(AbstractClassMetaData cmd, Result result, String tableName, StoreManager storeMgr) {
        VersionMetaData vermd = cmd.getVersionMetaDataForClass();
        String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
        String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
        String qualifName = HBaseUtils.getQualifierNameForColumnName(colName);
        Object version = null;
        try {
            byte[] bytes = result.getValue(familyName.getBytes(), qualifName.getBytes());
            if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                version = Bytes.toLong((byte[])bytes);
            } else {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                version = ois.readObject();
                ois.close();
                bis.close();
            }
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return version;
    }

    public static Put getPutForObject(ObjectProvider op) throws IOException {
        byte[] rowKey = (byte[])op.getAssociatedValue((Object)"HBASE_ROW_KEY");
        if (rowKey == null) {
            AbstractClassMetaData cmd = op.getClassMetaData();
            Object[] pkValues = HBaseUtils.findKeyObjects(op, cmd);
            ExecutionContext ec = op.getExecutionContext();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            rowKey = HBaseUtils.getRowKeyForPkValue(pkValues, ec.getNucleusContext());
        }
        return new Put(rowKey);
    }

    public static Delete getDeleteForObject(ObjectProvider op) throws IOException {
        byte[] rowKey = (byte[])op.getAssociatedValue((Object)"HBASE_ROW_KEY");
        if (rowKey == null) {
            AbstractClassMetaData cmd = op.getClassMetaData();
            Object[] pkValues = HBaseUtils.findKeyObjects(op, cmd);
            ExecutionContext ec = op.getExecutionContext();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            rowKey = HBaseUtils.getRowKeyForPkValue(pkValues, ec.getNucleusContext());
        }
        return new Delete(rowKey);
    }

    public static Result getResultForObject(ObjectProvider op, HTable table) throws IOException {
        byte[] rowKey = (byte[])op.getAssociatedValue((Object)"HBASE_ROW_KEY");
        if (rowKey == null) {
            AbstractClassMetaData cmd = op.getClassMetaData();
            Object[] pkValues = HBaseUtils.findKeyObjects(op, cmd);
            ExecutionContext ec = op.getExecutionContext();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            rowKey = HBaseUtils.getRowKeyForPkValue(pkValues, ec.getNucleusContext());
        }
        Get get = new Get(rowKey);
        return table.get(get);
    }

    public static boolean objectExistsInTable(ObjectProvider op, HTable table) throws IOException {
        byte[] rowKey = (byte[])op.getAssociatedValue((Object)"HBASE_ROW_KEY");
        if (rowKey == null) {
            AbstractClassMetaData cmd = op.getClassMetaData();
            Object[] pkValues = HBaseUtils.findKeyObjects(op, cmd);
            ExecutionContext ec = op.getExecutionContext();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            rowKey = HBaseUtils.getRowKeyForPkValue(pkValues, ec.getNucleusContext());
        }
        Get get = new Get(rowKey);
        return table.exists(get);
    }

    private static Object[] findKeyObjects(ObjectProvider op, AbstractClassMetaData cmd) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return new Object[]{((OID)op.getInternalObjectId()).getKeyValue()};
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] fieldNumbers = op.getClassMetaData().getPKMemberPositions();
            Object[] keyObjects = new Object[fieldNumbers.length];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                keyObjects[i] = op.provideField(fieldNumbers[i]);
            }
            return keyObjects;
        }
        int[] fieldNumbers = op.getClassMetaData().getAllMemberPositions();
        Object[] keyObjects = new Object[fieldNumbers.length];
        for (int i = 0; i < fieldNumbers.length; ++i) {
            keyObjects[i] = op.provideField(fieldNumbers[i]);
        }
        return keyObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getRowKeyForPkValue(Object[] pkValues, NucleusContext nucCtx) throws IOException {
        boolean useSerialisation = nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.hbase.serialisedPK");
        if (pkValues.length == 1 && !useSerialisation) {
            Object pkValue = pkValues[0];
            if (pkValue instanceof String) {
                return Bytes.toBytes((String)((String)pkValue));
            }
            if (pkValue instanceof Long) {
                return Bytes.toBytes((long)((Long)pkValue));
            }
            if (pkValue instanceof Integer) {
                return Bytes.toBytes((int)((Integer)pkValue));
            }
            if (pkValue instanceof Short) {
                return Bytes.toBytes((short)((Short)pkValue));
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (useSerialisation) {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                try {
                    for (Object pkValue : pkValues) {
                        oos.writeObject(pkValue);
                    }
                }
                finally {
                    oos.close();
                }
            } else {
                for (Object pkValue : pkValues) {
                    if (pkValue instanceof String) {
                        bos.write(Bytes.toBytes((String)((String)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Long) {
                        bos.write(Bytes.toBytes((long)((Long)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Integer) {
                        bos.write(Bytes.toBytes((int)((Integer)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Short) {
                        bos.write(Bytes.toBytes((short)((Short)pkValue)));
                        continue;
                    }
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    try {
                        oos.writeObject(pkValue);
                    }
                    finally {
                        oos.close();
                    }
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            bos.close();
        }
    }
}

