/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hbase.filter.Filter;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.query.expression.HBaseBooleanExpression;
import org.datanucleus.store.hbase.query.expression.HBaseExpression;
import org.datanucleus.store.hbase.query.expression.HBaseFieldExpression;
import org.datanucleus.store.hbase.query.expression.HBaseLiteral;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryToHBaseMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    CompilationComponent compileComponent;
    Filter filter = null;
    boolean filterComplete = true;
    Stack<HBaseExpression> stack = new Stack();

    public QueryToHBaseMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void compile() {
        this.compileFilter();
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                HBaseExpression filterExpr = this.stack.pop();
                if (filterExpr instanceof HBaseBooleanExpression) {
                    this.filter = ((HBaseBooleanExpression)filterExpr).getFilter();
                } else {
                    NucleusLogger.QUERY.error((Object)(">> invalid compilation : filter compiled to " + filterExpr));
                    this.filterComplete = false;
                }
            }
            catch (Exception e) {
                this.filterComplete = false;
                NucleusLogger.QUERY.debug((Object)">> compileFilter caught exception ", (Throwable)e);
            }
            this.compileComponent = null;
        }
    }

    protected Object processOrExpression(Expression expr) {
        HBaseBooleanExpression right = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression left = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression orExpr = new HBaseBooleanExpression(left, right, (Expression.Operator)Expression.OP_OR);
        this.stack.push(orExpr);
        return orExpr;
    }

    protected Object processAndExpression(Expression expr) {
        HBaseBooleanExpression right = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression left = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression andExpr = new HBaseBooleanExpression(left, right, (Expression.Operator)Expression.OP_AND);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processEqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_EQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_EQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processNoteqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_GT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processGtExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_LT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processLtExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_LT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processGteqExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_GT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litExpr.getValue(), (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processLteqExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            List tuples = expr.getTuples();
            String famColName = this.getFamilyColumnNameForPrimary(tuples);
            if (famColName == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)(">> Primary " + expr + " is not stored in this document, so unexecutable in datastore"));
            } else {
                int sepPos = famColName.indexOf("###");
                String familyName = famColName.substring(0, sepPos);
                String columnName = famColName.substring(sepPos + 3);
                HBaseFieldExpression fieldExpr = new HBaseFieldExpression(familyName, columnName);
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
        }
        return super.processPrimaryExpression(expr);
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        return super.processParameterExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof Number) {
            HBaseLiteral lit = new HBaseLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof String) {
            HBaseLiteral lit = new HBaseLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        return super.processLiteral(expr);
    }

    protected String getFamilyColumnNameForPrimary(List<String> tuples) {
        if (tuples == null || tuples.size() == 0) {
            return null;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = this.candidateCmd;
        Iterator<String> iter = tuples.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (name.equals(this.candidateAlias)) {
                cmd = this.candidateCmd;
                continue;
            }
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(name);
            int relationType = mmd.getRelationType(clr);
            if (relationType == 0) {
                if (iter.hasNext()) {
                    throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString(tuples) + " yet " + name + " is a non-relation field!");
                }
                String familyName = HBaseUtils.getFamilyName(cmd, mmd.getAbsoluteFieldNumber());
                String columnName = HBaseUtils.getQualifierName(cmd, mmd.getAbsoluteFieldNumber());
                return familyName + "###" + columnName;
            }
            if (this.compileComponent == CompilationComponent.FILTER) {
                this.filterComplete = false;
            }
            NucleusLogger.QUERY.debug((Object)("Query has reference to " + StringUtils.collectionToString(tuples) + " and " + mmd.getFullFieldName() + " is not persisted into this document, so unexecutable in the datastore"));
            return null;
        }
        return null;
    }
}

