/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.types.ObjectStringConverter;

public class StoreFieldManager
extends AbstractFieldManager {
    ObjectProvider sm;
    Put put;
    Delete delete;
    AbstractClassMetaData acmd;

    public StoreFieldManager(ObjectProvider sm, Put put, Delete delete) {
        this.sm = sm;
        this.acmd = sm.getClassMetaData();
        this.put = put;
        this.delete = delete;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeBoolean(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        this.put.add(familyName.getBytes(), columnName.getBytes(), new byte[]{value});
    }

    public void storeCharField(int fieldNumber, char value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeChar(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), ("" + value).getBytes());
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeDouble(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeFloat(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeLong(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeObjectField(int fieldNumber, Object value) {
        ExecutionContext ec = this.sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(clr);
        if ((relationType == 2 || relationType == 1) && mmd.isEmbedded()) {
            Class embcls = mmd.getType();
            AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
            if (embcmd == null) throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
            if (value == null) {
                this.deleteColumnsForEmbeddedMember(mmd, clr, ec);
                return;
            }
            ObjectProvider embSM = ec.findObjectProviderForEmbedded(value, this.sm, mmd);
            embSM.addEmbeddedOwner(this.sm, fieldNumber);
            StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embSM, this.put, this.delete, mmd, HBaseUtils.getTableName(this.acmd));
            embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
            return;
        }
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
            return;
        }
        if (relationType == 2 || relationType == 1 || relationType == 6 || relationType == 7) {
            Object valuePC = this.sm.getExecutionContext().persistObjectInternal(value, this.sm, fieldNumber, -1);
            if (mmd.isSerialized()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                    return;
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            } else {
                Object valueId = ec.getApiAdapter().getIdForObject(valuePC);
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(valueId);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                    return;
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (relationType == 3 || relationType == 4 || relationType == 5) {
            if (mmd.hasCollection()) {
                ObjectOutputStream oos;
                ByteArrayOutputStream bos;
                ArrayList<Object> collIds = new ArrayList<Object>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.sm.getExecutionContext().persistObjectInternal(element, this.sm, fieldNumber, -1);
                    Object elementID = this.sm.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    collIds.add(elementID);
                }
                if (mmd.isSerialized()) {
                    try {
                        bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(value);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(collIds);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
            } else if (mmd.hasMap()) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    if (ec.getApiAdapter().isPersistable(mapKey)) {
                        ec.persistObjectInternal(mapKey, this.sm, fieldNumber, -1);
                    }
                    if (!ec.getApiAdapter().isPersistable(mapValue)) continue;
                    ec.persistObjectInternal(mapValue, this.sm, fieldNumber, -1);
                }
                if (!mmd.isSerialized()) throw new NucleusException("Only currently support maps serialised with HBase. Mark the field as serialized");
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                    return;
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            } else {
                ObjectOutputStream oos;
                if (!mmd.hasArray()) return;
                ArrayList<Object> arrIds = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    Object elementPC = ec.persistObjectInternal(element, this.sm, fieldNumber, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    arrIds.add(elementID);
                }
                if (mmd.isSerialized()) {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(value);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(arrIds);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        ObjectStringConverter strConv = ec.getNucleusContext().getTypeManager().getStringConverter(value.getClass());
        if (!mmd.isSerialized() && strConv != null) {
            String strValue = strConv.toString(value);
            this.put.add(familyName.getBytes(), columnName.getBytes(), strValue.getBytes());
            return;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
            return;
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected void deleteColumnsForEmbeddedMember(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec) {
        Class embcls = mmd.getType();
        AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
        if (embcmd != null) {
            EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            String tableName = HBaseUtils.getTableName(this.acmd);
            for (int i = 0; i < embmmds.length; ++i) {
                int relationType = embmmds[i].getRelationType(clr);
                if ((relationType == 2 || relationType == 1) && embmmds[i].isEmbedded()) {
                    this.deleteColumnsForEmbeddedMember(embmmds[i], clr, ec);
                    continue;
                }
                String familyName = HBaseUtils.getFamilyName(mmd, i, tableName);
                String columnName = HBaseUtils.getQualifierName(mmd, i);
                this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
            }
            return;
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeShort(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        String familyName = HBaseUtils.getFamilyName(this.acmd, fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.acmd, fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
        } else {
            AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (mmd.isSerialized()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            } else {
                this.put.add(familyName.getBytes(), columnName.getBytes(), value.getBytes());
            }
        }
    }
}

