/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.store.types.sco.SCOUtils;

public class FetchEmbeddedFieldManager
extends AbstractFieldManager {
    private final AbstractMemberMetaData mmd;
    private final Result result;
    private final ExecutionContext ec;
    private final ObjectProvider sm;
    private final String tableName;

    public FetchEmbeddedFieldManager(ObjectProvider sm, Result result, AbstractMemberMetaData mmd, String tableName) {
        this.result = result;
        this.sm = sm;
        this.ec = sm.getExecutionContext();
        this.mmd = mmd;
        this.tableName = tableName;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        boolean value;
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readBoolean();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public byte fetchByteField(int fieldNumber) {
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        return bytes[0];
    }

    public char fetchCharField(int fieldNumber) {
        char value;
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        AbstractMemberMetaData embMmd = this.mmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            if (embMmd.isSerialized()) {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readChar();
                ois.close();
                bis.close();
            } else {
                String strValue = new String(bytes);
                value = strValue.charAt(0);
            }
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public double fetchDoubleField(int fieldNumber) {
        double value;
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readDouble();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public float fetchFloatField(int fieldNumber) {
        float value;
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readFloat();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public int fetchIntField(int fieldNumber) {
        int value;
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readInt();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public long fetchLongField(int fieldNumber) {
        long value;
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readLong();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public short fetchShortField(int fieldNumber) {
        short value;
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readShort();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public String fetchStringField(int fieldNumber) {
        String value;
        block6: {
            String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
            String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
            AbstractMemberMetaData embMmd = this.mmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
            try {
                byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
                if (bytes != null) {
                    if (embMmd.isSerialized()) {
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream ois = new ObjectInputStream(bis);
                        value = (String)ois.readObject();
                        ois.close();
                        bis.close();
                    } else {
                        value = new String(bytes);
                    }
                    break block6;
                }
                return null;
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    public Object fetchObjectField(int fieldNumber) {
        Object value;
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData embMmd = this.mmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        int relationType = embMmd.getRelationType(clr);
        if ((relationType == 1 || relationType == 2) && embMmd.isEmbedded()) {
            Class embcls = embMmd.getType();
            AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
            if (embcmd != null) {
                EmbeddedMetaData embmd = this.mmd.getEmbeddedMetaData();
                AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                boolean isNull = true;
                for (int i = 0; i < embmmds.length; ++i) {
                    String familyName = HBaseUtils.getFamilyName(this.mmd, i, this.tableName);
                    String columnName = HBaseUtils.getQualifierName(this.mmd, i);
                    if (this.result.getValue(familyName.getBytes(), columnName.getBytes()) == null) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.newObjectProviderForMember(embMmd, embcmd);
                embSM.addEmbeddedOwner(this.sm, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.result, embMmd, this.tableName);
                embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            throw new NucleusUserException("Field " + this.mmd.getFullFieldName() + " marked as embedded but no such metadata");
        }
        String familyName = HBaseUtils.getFamilyName(this.mmd, fieldNumber, this.tableName);
        String columnName = HBaseUtils.getQualifierName(this.mmd, fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        if (relationType == 2 || relationType == 1 || relationType == 6 || relationType == 7) {
            if (embMmd.isSerialized()) {
                return value;
            }
            return this.ec.findObject(value, true, true, null);
        }
        if (relationType == 3 || relationType == 4 || relationType == 5) {
            if (embMmd.hasCollection()) {
                Collection coll;
                if (embMmd.isSerialized()) {
                    return value;
                }
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)embMmd.getType(), (Boolean)(embMmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Collection collIds = (Collection)value;
                for (Object elementId : collIds) {
                    coll.add(this.ec.findObject(elementId, true, true, null));
                }
                return coll;
            }
            if (embMmd.hasMap()) {
                if (embMmd.isSerialized()) {
                    return value;
                }
            } else if (embMmd.hasArray()) {
                if (embMmd.isSerialized()) {
                    return value;
                }
                Collection arrIds = (Collection)value;
                Object array = Array.newInstance(embMmd.getType().getComponentType(), arrIds.size());
                Iterator idIter = arrIds.iterator();
                int i = 0;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    Array.set(array, i, this.ec.findObject(elementId, true, true, null));
                }
                return array;
            }
            throw new NucleusUserException("No container that isnt collection/map/array");
        }
        ObjectStringConverter strConv = this.sm.getExecutionContext().getNucleusContext().getTypeManager().getStringConverter(value.getClass());
        if (!embMmd.isSerialized() && strConv != null) {
            String strValue = (String)value;
            return strConv.toObject(strValue);
        }
        return value;
    }
}

