/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBaseUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());

    public static String getTableName(AbstractClassMetaData acmd) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return acmd.getName();
    }

    public static String getFamilyName(AbstractMemberMetaData mmd, int fieldNumber, String tableNameForClass) {
        AbstractMemberMetaData[] embmmds;
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null && (colmds = (embMmd = (embmmds = embmd.getMemberMetaData())[fieldNumber]).getColumnMetaData()) != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return tableNameForClass;
    }

    public static String getQualifierName(AbstractMemberMetaData mmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(IdentityMetaData idmd) {
        String columnName = null;
        ColumnMetaData[] colmds = idmd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)idmd.getParent());
    }

    public static String getQualifierName(IdentityMetaData idmd) {
        String columnName = null;
        ColumnMetaData[] colmds = idmd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = "IDENTITY";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(VersionMetaData vermd) {
        String columnName = null;
        ColumnMetaData[] colmds = vermd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)vermd.getParent());
    }

    public static String getQualifierName(VersionMetaData vermd) {
        String columnName = null;
        ColumnMetaData[] colmds = vermd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = "VERSION";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName(acmd);
    }

    public static String getQualifierName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = ammd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    static void createSchemaForClass(final HBaseStoreManager storeMgr, final AbstractClassMetaData acmd, final boolean validateOnly) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final HBaseConfiguration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin((Configuration)config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    block3: {
                        String tableName = HBaseUtils.getTableName(acmd);
                        hTable = null;
                        try {
                            hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                        }
                        catch (TableNotFoundException ex) {
                            if (validateOnly) {
                                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                                hTable = null;
                            }
                            if (!storeMgr.isAutoCreateTables()) break block3;
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                            hTable = new HTableDescriptor(tableName);
                            hBaseAdmin.createTable(hTable);
                        }
                    }
                    return hTable;
                }
            });
            if (hTable != null) {
                boolean modified = false;
                String tableName = HBaseUtils.getTableName(acmd);
                if (!hTable.hasFamily(tableName.getBytes())) {
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)tableName));
                    } else if (storeMgr.isAutoCreateColumns()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)tableName));
                        HColumnDescriptor hColumn = new HColumnDescriptor(tableName);
                        hTable.addFamily(hColumn);
                        modified = true;
                    }
                }
                int[] fieldNumbers = acmd.getAllMemberPositions();
                ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    int relationType = mmd.getRelationType(clr);
                    if ((relationType == 1 || relationType == 2) && mmd.isEmbedded()) {
                        HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, mmd, clr, validateOnly);
                        continue;
                    }
                    String familyName = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]);
                    if (hTable.hasFamily(familyName.getBytes())) continue;
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                        continue;
                    }
                    if (!storeMgr.isAutoCreateColumns()) continue;
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
                    HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                    hTable.addFamily(hColumn);
                    modified = true;
                }
                if (modified) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            hBaseAdmin.disableTable(hTable.getName());
                            hBaseAdmin.modifyTable(hTable.getName(), hTable);
                            hBaseAdmin.enableTable(hTable.getName());
                            return null;
                        }
                    });
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    static boolean createSchemaForEmbeddedMember(HBaseStoreManager storeMgr, HTableDescriptor hTable, AbstractMemberMetaData mmd, ClassLoaderResolver clr, boolean validateOnly) {
        boolean modified = false;
        String tableName = hTable.getNameAsString();
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int j = 0; j < embmmds.length; ++j) {
            AbstractMemberMetaData embMmd = embmmds[j];
            int embRelationType = embMmd.getRelationType(clr);
            if ((embRelationType == 1 || embRelationType == 2) && embMmd.isEmbedded()) {
                return HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, embMmd, clr, validateOnly);
            }
            String familyName = HBaseUtils.getFamilyName(embMmd, j, tableName);
            if (hTable.hasFamily(familyName.getBytes())) continue;
            if (validateOnly) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                continue;
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
            HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
            hTable.addFamily(hColumn);
            modified = true;
        }
        return modified;
    }

    static void deleteSchemaForClass(HBaseStoreManager storeMgr, final AbstractClassMetaData acmd) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final HBaseConfiguration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin((Configuration)config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    String tableName = HBaseUtils.getTableName(acmd);
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                    }
                    catch (TableNotFoundException ex) {
                        hTable = new HTableDescriptor(tableName);
                        hBaseAdmin.createTable(hTable);
                    }
                    return hTable;
                }
            });
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaDelete.Class", (Object)acmd.getFullClassName(), (Object)hTable.getNameAsString()));
                    hBaseAdmin.disableTable(hTable.getName());
                    hBaseAdmin.deleteTable(hTable.getName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }
}

