/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.util.Localiser;

public class HBaseMetaDataListener
implements MetaDataListener {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    private HBaseStoreManager storeManager;

    HBaseMetaDataListener(HBaseStoreManager storeManager) {
        this.storeManager = storeManager;
    }

    public void loaded(AbstractClassMetaData cmd) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE && !cmd.isEmbeddedOnly()) {
            throw new InvalidMetaDataException(LOCALISER, "HBase.DatastoreID", (Object)cmd.getFullClassName());
        }
        if (this.storeManager.isAutoCreateTables() || this.storeManager.isAutoCreateColumns()) {
            HBaseUtils.createSchema(this.storeManager.getHbaseConfig(), cmd, this.storeManager.isAutoCreateColumns());
        }
    }
}

