/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseFetchFieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;

public class HBaseUtils {
    public static String getTableName(AbstractClassMetaData acmd) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return acmd.getName();
    }

    public static String getFamilyName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = HBaseUtils.getTableName(acmd);
        } else if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(0, columnName.indexOf(":"));
        }
        return columnName;
    }

    public static String getQualifierName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = ammd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static List getObjectsOfCandidateType(final ObjectManager om, HBaseManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            final ClassLoaderResolver clr = om.getClassLoaderResolver();
            final AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            Scan scan = new Scan();
            int[] fieldNumbers = acmd.getAllMemberPositions();
            for (int i = 0; i < fieldNumbers.length; ++i) {
                byte[] familyNames = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]).getBytes();
                byte[] columnNames = HBaseUtils.getQualifierName(acmd, fieldNumbers[i]).getBytes();
                scan.addColumn(familyNames, columnNames);
            }
            ResultScanner scanner = table.getScanner(scan);
            for (final Result result : scanner) {
                results.add(om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), new FieldValues(){

                    public void fetchFields(StateManager sm) {
                        sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new HBaseFetchFieldManager(sm, result));
                        sm.replaceFields(acmd.getBasicMemberPositions(clr, om.getMetaDataManager()), (FieldManager)new HBaseFetchFieldManager(sm, result));
                    }

                    public void fetchNonLoadedFields(StateManager sm) {
                        sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new HBaseFetchFieldManager(sm, result));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, ignoreCache, true));
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public static void createSchema(HBaseConfiguration config, AbstractClassMetaData acmd, boolean autoCreateColumns) throws IOException {
        HTableDescriptor hTable;
        HBaseAdmin hBaseAdmin = new HBaseAdmin(config);
        String tableName = HBaseUtils.getTableName(acmd);
        try {
            hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
        }
        catch (TableNotFoundException ex) {
            hTable = new HTableDescriptor(tableName);
            hBaseAdmin.createTable(hTable);
        }
        if (autoCreateColumns) {
            boolean modified = false;
            if (!hTable.hasFamily(HBaseUtils.getTableName(acmd).getBytes())) {
                HColumnDescriptor hColumn = new HColumnDescriptor(HBaseUtils.getTableName(acmd));
                hTable.addFamily(hColumn);
                modified = true;
            }
            int[] fieldNumbers = acmd.getAllMemberPositions();
            for (int i = 0; i < fieldNumbers.length; ++i) {
                String familyName = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]);
                if (hTable.hasFamily(familyName.getBytes())) continue;
                HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                hTable.addFamily(hColumn);
                modified = true;
            }
            if (modified) {
                hBaseAdmin.disableTable(hTable.getName());
                hBaseAdmin.modifyTable(hTable.getName(), hTable);
                hBaseAdmin.enableTable(hTable.getName());
            }
        }
    }
}

