/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.RowResult;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseFetchFieldManager;
import org.datanucleus.store.hbase.HBaseInsertFieldManager;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class HBasePersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    protected final HBaseStoreManager storeMgr;

    HBasePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (HBaseStoreManager)storeMgr;
    }

    public void close() {
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            HBaseConfiguration config = (HBaseConfiguration)mconn.getConnection();
            AbstractClassMetaData acmd = sm.getClassMetaData();
            this.createSchema(config, acmd);
            HTable table = new HTable(config, HBaseUtils.getTableName(acmd));
            table.deleteAll(this.getRowBytes(sm));
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            HBaseConfiguration config = (HBaseConfiguration)mconn.getConnection();
            AbstractClassMetaData acmd = sm.getClassMetaData();
            this.createSchema(config, acmd);
            HTable table = new HTable(config, HBaseUtils.getTableName(acmd));
            RowResult result = this.getRowResult(sm, table);
            if (result == null) {
                throw new NucleusObjectNotFoundException();
            }
            HBaseFetchFieldManager fm = new HBaseFetchFieldManager(sm, result);
            sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)fm);
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        try {
            this.locateObject(sm);
            throw new NucleusUserException(LOCALISER.msg("HBase.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
        }
        catch (NucleusObjectNotFoundException onfe) {
            this.storeMgr.addClass(sm.getClassMetaData().getFullClassName(), sm.getObjectManager().getClassLoaderResolver());
            ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
            try {
                HBaseConfiguration config = (HBaseConfiguration)mconn.getConnection();
                AbstractClassMetaData acmd = sm.getClassMetaData();
                this.createSchema(config, acmd);
                HTable table = new HTable(config, HBaseUtils.getTableName(acmd));
                BatchUpdate batch = this.newBatchUpdate(sm);
                HBaseInsertFieldManager fm = new HBaseInsertFieldManager(sm, batch);
                sm.provideFields(acmd.getAllMemberPositions(), (FieldManager)fm);
                table.commit(batch);
                table.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
            return;
        }
    }

    private BatchUpdate newBatchUpdate(StateManager sm) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        BatchUpdate batch = new BatchUpdate(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    private RowResult getRowResult(StateManager sm, HTable table) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        RowResult result = table.getRow(bos.toByteArray());
        oos.close();
        bos.close();
        return result;
    }

    private byte[] getRowBytes(StateManager sm) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        byte[] bytes = bos.toByteArray();
        oos.close();
        bos.close();
        return bytes;
    }

    private void createSchema(HBaseConfiguration config, AbstractClassMetaData acmd) throws IOException {
        HColumnDescriptor hColumn;
        HTableDescriptor hTable;
        HBaseAdmin hBaseAdmin = new HBaseAdmin(config);
        String tableName = HBaseUtils.getTableName(acmd);
        boolean isNew = false;
        try {
            hTable = hBaseAdmin.getTableDescriptor(tableName);
        }
        catch (TableNotFoundException ex) {
            isNew = true;
            hTable = new HTableDescriptor(tableName);
            hBaseAdmin.createTable(hTable);
        }
        if (isNew) {
            // empty if block
        }
        if ((hColumn = hTable.getFamily(HBaseUtils.getTableName(acmd).getBytes())) == null) {
            hColumn = new HColumnDescriptor(HBaseUtils.getTableName(acmd) + ":");
            hTable.addFamily(hColumn);
            hBaseAdmin.disableTable(hTable.getName());
            hBaseAdmin.modifyTable(hTable.getName(), hTable);
            hBaseAdmin.enableTable(hTable.getName());
        }
    }

    public void locateObject(StateManager sm) {
        this.fetchObject(sm, sm.getClassMetaData().getAllMemberPositions());
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            HBaseConfiguration config = (HBaseConfiguration)mconn.getConnection();
            AbstractClassMetaData acmd = sm.getClassMetaData();
            this.createSchema(config, acmd);
            HTable table = new HTable(config, HBaseUtils.getTableName(acmd));
            BatchUpdate batch = this.newBatchUpdate(sm);
            HBaseInsertFieldManager fm = new HBaseInsertFieldManager(sm, batch);
            sm.provideFields(fieldNumbers, (FieldManager)fm);
            table.commit(batch);
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }
}

