/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.adapter;

import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import oracle.spatial.geometry.JGeometry;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.MySQLAdapter;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.types.geospatial.rdbms.adapter.MySQLSpatialTypeInfo;
import org.datanucleus.store.types.geospatial.rdbms.adapter.SpatialRDBMSAdapter;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jgeom2mysql.JGeometryColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.LineStringColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.LinearRingColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.MultiPolygonColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.PointColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.GeometryCollectionColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.GeometryColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.MultiLineStringColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.MultiPointColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.PolygonColumnMapping;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.MySqlMbrContainsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.MySqlMbrDisjointMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.MySqlMbrEqualMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.MySqlMbrIntersectsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.MySqlMbrOverlapsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.MySqlMbrTouchesMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.MySqlMbrWithinMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAreaMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAsBinaryMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAsTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBboxTestMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBoundaryMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBoundaryMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBufferMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialCentroidMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialContainsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialConvexHullMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialCrossesMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDifferenceMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDimensionMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDisjointMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDistanceMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEndPointMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEnvelopeMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEqualsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialExteriorRingMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomCollFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomCollFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeometryNMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeometryTypeMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialInteriorRingNMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIntersectionMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIntersectsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsClosedMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsEmptyMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsEmptyMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsRingMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsSimpleMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialLengthMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialLineFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialLineFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMLineFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMLineFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPointFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPointFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPolyFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPolyFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumGeometriesMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumInteriorRingMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumPointsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialOverlapsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointNMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointOnSurfaceMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPolyFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPolyFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialRelateMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialRelateMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialSridMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialStartPointMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialSymDifferenceMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialTouchesMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialUnionMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialWithinMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialXMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialYMethod;
import org.datanucleus.util.NucleusLogger;
import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.Point;

public class MySQLSpatialAdapter
extends MySQLAdapter
implements SpatialRDBMSAdapter {
    public MySQLSpatialAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        MySQLSpatialTypeInfo sqlType = MySQLSpatialTypeInfo.TYPEINFO_PROTOTYPE;
        this.addSQLTypeForJDBCType(handler, mconn, (short)-2, sqlType, true);
    }

    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        Class cls;
        try {
            cls = clr.classForName("oracle.spatial.geometry.JGeometry");
            if (cls != null) {
                this.registerColumnMapping(JGeometry.class.getName(), JGeometryColumnMapping.class, JDBCType.BINARY, "geometry", true);
            }
        }
        catch (Throwable thr) {
            NucleusLogger.DATASTORE.warn((Object)"Not loading RDBMS support for Oracle JGeometry since not present");
        }
        try {
            cls = clr.classForName("com.vividsolutions.jts.geom.Geometry");
            if (cls != null) {
                this.registerColumnMapping(com.vividsolutions.jts.geom.Geometry.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.GeometryColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(com.vividsolutions.jts.geom.GeometryCollection.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.GeometryCollectionColumnMapping.class, JDBCType.BINARY, "geometrycollection", true);
                this.registerColumnMapping(LinearRing.class.getName(), LinearRingColumnMapping.class, JDBCType.BINARY, "linestring", true);
                this.registerColumnMapping(com.vividsolutions.jts.geom.LineString.class.getName(), LineStringColumnMapping.class, JDBCType.BINARY, "linestring", true);
                this.registerColumnMapping(MultiLineString.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.MultiLineStringColumnMapping.class, JDBCType.BINARY, "multilinestring", true);
                this.registerColumnMapping(MultiPolygon.class.getName(), MultiPolygonColumnMapping.class, JDBCType.BINARY, "multipolygon", true);
                this.registerColumnMapping(MultiPoint.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.MultiPointColumnMapping.class, JDBCType.BINARY, "multipoint", true);
                this.registerColumnMapping(com.vividsolutions.jts.geom.Point.class.getName(), PointColumnMapping.class, JDBCType.BINARY, "point", true);
                this.registerColumnMapping(Polygon.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql.PolygonColumnMapping.class, JDBCType.BINARY, "polygon", true);
            }
        }
        catch (Throwable thr) {
            NucleusLogger.DATASTORE.warn((Object)"Not loading RDBMS support for Vividsolutions JTS types since not present");
        }
        try {
            cls = clr.classForName("org.postgis.Geometry");
            if (cls != null) {
                this.registerColumnMapping(Geometry.class.getName(), GeometryColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(GeometryCollection.class.getName(), GeometryCollectionColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(org.postgis.LinearRing.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.LinearRingColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(LineString.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.LineStringColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(org.postgis.MultiLineString.class.getName(), MultiLineStringColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(org.postgis.MultiPolygon.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.MultiPolygonColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(org.postgis.MultiPoint.class.getName(), MultiPointColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(Point.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql.PointColumnMapping.class, JDBCType.BINARY, "geometry", true);
                this.registerColumnMapping(org.postgis.Polygon.class.getName(), PolygonColumnMapping.class, JDBCType.BINARY, "geometry", true);
            }
        }
        catch (Throwable thr) {
            NucleusLogger.DATASTORE.warn((Object)"Not loading RDBMS support for PostGIS types since not present");
        }
        super.loadColumnMappings(mgr, clr);
    }

    @Override
    public boolean isGeometryColumn(Column c) {
        SQLTypeInfo typeInfo = c.getTypeInfo();
        if (typeInfo == null) {
            return false;
        }
        return typeInfo.getTypeName().equalsIgnoreCase("geometry") || typeInfo.getTypeName().equalsIgnoreCase("geometrycollection");
    }

    @Override
    public String getRetrieveCrsNameStatement(Table table, int srid) {
        return null;
    }

    @Override
    public String getRetrieveCrsWktStatement(Table table, int srid) {
        return null;
    }

    @Override
    public String getCalculateBoundsStatement(Table table, Column column) {
        return "SELECT min(X(PointN(ExteriorRing(Envelope(#column1)),1))), min(Y(PointN(ExteriorRing(Envelope(#column2)),1))), max(X(PointN(ExteriorRing(Envelope(#column3)),1))), max(Y(PointN(ExteriorRing(Envelope(#column4)),1))) " + "FROM #table".replace("#column", column.getIdentifier().getName()).replace("#table", table.getIdentifier().getName());
    }

    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("Spatial.envelope".equals(methodName)) {
                return SpatialEnvelopeMethod.class;
            }
            if ("Spatial.dimension".equals(methodName)) {
                return SpatialDimensionMethod.class;
            }
            if ("Spatial.boundary".equals(methodName)) {
                return SpatialBoundaryMethod.class;
            }
            if ("Spatial.srid".equals(methodName)) {
                return SpatialSridMethod.class;
            }
            if ("Spatial.isSimple".equals(methodName)) {
                return SpatialIsSimpleMethod3.class;
            }
            if ("Spatial.isEmpty".equals(methodName)) {
                return SpatialIsEmptyMethod3.class;
            }
            if ("Spatial.asBinary".equals(methodName)) {
                return SpatialAsBinaryMethod.class;
            }
            if ("Spatial.asText".equals(methodName)) {
                return SpatialAsTextMethod.class;
            }
            if ("Spatial.geometryType".equals(methodName)) {
                return SpatialGeometryTypeMethod.class;
            }
            if ("Spatial.contains".equals(methodName)) {
                return SpatialContainsMethod.class;
            }
            if ("Spatial.overlaps".equals(methodName)) {
                return SpatialOverlapsMethod.class;
            }
            if ("Spatial.touches".equals(methodName)) {
                return SpatialTouchesMethod.class;
            }
            if ("Spatial.crosses".equals(methodName)) {
                return SpatialCrossesMethod.class;
            }
            if ("Spatial.within".equals(methodName)) {
                return SpatialWithinMethod.class;
            }
            if ("Spatial.intersects".equals(methodName)) {
                return SpatialIntersectsMethod.class;
            }
            if ("Spatial.equals".equals(methodName)) {
                return SpatialEqualsMethod.class;
            }
            if ("Spatial.disjoint".equals(methodName)) {
                return SpatialDisjointMethod.class;
            }
            if ("Spatial.relate".equals(methodName)) {
                return SpatialRelateMethod3.class;
            }
            if ("Spatial.distance".equals(methodName)) {
                return SpatialDistanceMethod3.class;
            }
            if ("Spatial.intersection".equals(methodName)) {
                return SpatialIntersectionMethod.class;
            }
            if ("Spatial.buffer".equals(methodName)) {
                return SpatialBufferMethod.class;
            }
            if ("Spatial.convexHull".equals(methodName)) {
                return SpatialConvexHullMethod.class;
            }
            if ("Spatial.symDifference".equals(methodName)) {
                return SpatialSymDifferenceMethod.class;
            }
            if ("Spatial.difference".equals(methodName)) {
                return SpatialDifferenceMethod.class;
            }
            if ("Spatial.union".equals(methodName)) {
                return SpatialUnionMethod.class;
            }
            if ("Spatial.length".equals(methodName)) {
                return SpatialLengthMethod.class;
            }
            if ("Spatial.numPoints".equals(methodName)) {
                return SpatialNumPointsMethod.class;
            }
            if ("Spatial.centroid".equals(methodName)) {
                return SpatialCentroidMethod.class;
            }
            if ("Spatial.area".equals(methodName)) {
                return SpatialAreaMethod.class;
            }
            if ("Spatial.pointOnSurface".equals(methodName)) {
                return SpatialPointOnSurfaceMethod.class;
            }
            if ("Spatial.numGeometries".equals(methodName)) {
                return SpatialNumGeometriesMethod.class;
            }
            if ("Spatial.geometryN".equals(methodName)) {
                return SpatialGeometryNMethod.class;
            }
            if ("Spatial.x".equals(methodName)) {
                return SpatialXMethod.class;
            }
            if ("Spatial.y".equals(methodName)) {
                return SpatialYMethod.class;
            }
            if ("Spatial.isRing".equals(methodName)) {
                return SpatialIsRingMethod3.class;
            }
            if ("Spatial.isClosed".equals(methodName)) {
                return SpatialIsClosedMethod.class;
            }
            if ("Spatial.startPoint".equals(methodName)) {
                return SpatialStartPointMethod.class;
            }
            if ("Spatial.endPoint".equals(methodName)) {
                return SpatialEndPointMethod.class;
            }
            if ("Spatial.pointN".equals(methodName)) {
                return SpatialPointNMethod.class;
            }
            if ("Spatial.exteriorRing".equals(methodName)) {
                return SpatialExteriorRingMethod.class;
            }
            if ("Spatial.numInteriorRing".equals(methodName)) {
                return SpatialNumInteriorRingMethod.class;
            }
            if ("Spatial.interiorRingN".equals(methodName)) {
                return SpatialInteriorRingNMethod.class;
            }
            if ("Spatial.bboxTest".equals(methodName)) {
                return SpatialBboxTestMethod2.class;
            }
            if ("MySQL.mbrEqual".equals(methodName)) {
                return MySqlMbrEqualMethod.class;
            }
            if ("MySQL.mbrDisjoint".equals(methodName)) {
                return MySqlMbrDisjointMethod.class;
            }
            if ("MySQL.mbrIntersects".equals(methodName)) {
                return MySqlMbrIntersectsMethod.class;
            }
            if ("MySQL.mbrTouches".equals(methodName)) {
                return MySqlMbrTouchesMethod.class;
            }
            if ("MySQL.mbrWithin".equals(methodName)) {
                return MySqlMbrWithinMethod.class;
            }
            if ("MySQL.mbrContains".equals(methodName)) {
                return MySqlMbrContainsMethod.class;
            }
            if ("MySQL.mbrOverlaps".equals(methodName)) {
                return MySqlMbrOverlapsMethod.class;
            }
            if ("Spatial.geomFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod.class;
            }
            if ("Spatial.pointFromText".equals(methodName)) {
                return SpatialPointFromTextMethod.class;
            }
            if ("Spatial.lineFromText".equals(methodName)) {
                return SpatialLineFromTextMethod.class;
            }
            if ("Spatial.polyFromText".equals(methodName)) {
                return SpatialPolyFromTextMethod.class;
            }
            if ("Spatial.mLineFromText".equals(methodName)) {
                return SpatialMLineFromTextMethod.class;
            }
            if ("Spatial.mPointFromText".equals(methodName)) {
                return SpatialMPointFromTextMethod.class;
            }
            if ("Spatial.mPolyFromText".equals(methodName)) {
                return SpatialMPolyFromTextMethod.class;
            }
            if ("Spatial.geomCollFromText".equals(methodName)) {
                return SpatialGeomCollFromTextMethod.class;
            }
            if ("Spatial.geomFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod.class;
            }
            if ("Spatial.geomCollFromWKB".equals(methodName)) {
                return SpatialGeomCollFromWKBMethod.class;
            }
            if ("Spatial.pointFromWKB".equals(methodName)) {
                return SpatialPointFromWKBMethod.class;
            }
            if ("Spatial.mPointFromWKB".equals(methodName)) {
                return SpatialMPointFromWKBMethod.class;
            }
            if ("Spatial.lineFromWKB".equals(methodName)) {
                return SpatialLineFromWKBMethod.class;
            }
            if ("Spatial.mLineFromWKB".equals(methodName)) {
                return SpatialMLineFromWKBMethod.class;
            }
            if ("Spatial.polyFromWKB".equals(methodName)) {
                return SpatialPolyFromWKBMethod.class;
            }
            if ("Spatial.mPolyFromWKB".equals(methodName)) {
                return SpatialMPolyFromWKBMethod.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            boolean isGeometry = false;
            boolean isPoint = false;
            boolean isLineString = false;
            boolean isLinearRing = false;
            boolean isMultiLineString = false;
            boolean isPolygon = false;
            if (className.startsWith("com.vividsolutions.jts")) {
                if (com.vividsolutions.jts.geom.Geometry.class.getName().equals(className) || cls != null && com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(cls)) {
                    isGeometry = true;
                }
                if (com.vividsolutions.jts.geom.Point.class.getName().equals(className) || cls != null && com.vividsolutions.jts.geom.Point.class.isAssignableFrom(cls)) {
                    isPoint = true;
                }
                if (com.vividsolutions.jts.geom.LineString.class.getName().equals(className) || cls != null && com.vividsolutions.jts.geom.LineString.class.isAssignableFrom(cls)) {
                    isLineString = true;
                }
                if (MultiLineString.class.getName().equals(className) || cls != null && MultiLineString.class.isAssignableFrom(cls)) {
                    isMultiLineString = true;
                }
                if (LinearRing.class.getName().equals(className) || cls != null && LinearRing.class.isAssignableFrom(cls)) {
                    isLinearRing = true;
                }
                if (Polygon.class.getName().equals(className) || cls != null && Polygon.class.isAssignableFrom(cls)) {
                    isPolygon = true;
                }
            } else if (className.startsWith("org.postgis")) {
                if (Geometry.class.getName().equals(className) || cls != null && Geometry.class.isAssignableFrom(cls)) {
                    isGeometry = true;
                }
                if (Point.class.getName().equals(className) || cls != null && Point.class.isAssignableFrom(cls)) {
                    isPoint = true;
                }
                if (LineString.class.getName().equals(className) || cls != null && LineString.class.isAssignableFrom(cls)) {
                    isLineString = true;
                }
                if (org.postgis.MultiLineString.class.getName().equals(className) || cls != null && org.postgis.MultiLineString.class.isAssignableFrom(cls)) {
                    isMultiLineString = true;
                }
                if (org.postgis.LinearRing.class.getName().equals(className) || cls != null && org.postgis.LinearRing.class.isAssignableFrom(cls)) {
                    isLinearRing = true;
                }
                if (org.postgis.Polygon.class.getName().equals(className) || cls != null && org.postgis.Polygon.class.isAssignableFrom(cls)) {
                    isPolygon = true;
                }
            } else if (className.startsWith("oracle.spatial")) {
                isGeometry = true;
                isPoint = true;
                isLineString = true;
                isLinearRing = true;
                isMultiLineString = true;
                isPolygon = true;
            }
            if (isGeometry) {
                if ("getEnvelope".equals(methodName)) {
                    return SpatialEnvelopeMethod.class;
                }
                if ("getDimension".equals(methodName)) {
                    return SpatialDimensionMethod.class;
                }
                if ("getBoundary".equals(methodName)) {
                    return SpatialBoundaryMethod3.class;
                }
                if ("getSRID".equals(methodName)) {
                    return SpatialSridMethod.class;
                }
                if ("isSimple".equals(methodName)) {
                    return SpatialIsSimpleMethod3.class;
                }
                if ("isEmpty".equals(methodName)) {
                    return SpatialIsEmptyMethod.class;
                }
                if ("toText".equals(methodName)) {
                    return SpatialAsTextMethod.class;
                }
                if ("toBinary".equals(methodName)) {
                    return SpatialAsBinaryMethod.class;
                }
                if ("getGeometryType".equals(methodName)) {
                    return SpatialGeometryTypeMethod.class;
                }
                if ("contains".equals(methodName)) {
                    return SpatialContainsMethod.class;
                }
                if ("overlaps".equals(methodName)) {
                    return SpatialOverlapsMethod.class;
                }
                if ("touches".equals(methodName)) {
                    return SpatialTouchesMethod.class;
                }
                if ("crosses".equals(methodName)) {
                    return SpatialCrossesMethod.class;
                }
                if ("within".equals(methodName)) {
                    return SpatialWithinMethod.class;
                }
                if ("intersects".equals(methodName)) {
                    return SpatialIntersectsMethod.class;
                }
                if ("equals".equals(methodName)) {
                    return SpatialEqualsMethod.class;
                }
                if ("disjoint".equals(methodName)) {
                    return SpatialDisjointMethod.class;
                }
                if ("relate".equals(methodName)) {
                    return SpatialRelateMethod.class;
                }
                if ("distance".equals(methodName)) {
                    return SpatialDistanceMethod3.class;
                }
                if ("intersection".equals(methodName)) {
                    return SpatialIntersectionMethod.class;
                }
                if ("buffer".equals(methodName)) {
                    return SpatialBufferMethod.class;
                }
                if ("convexHull".equals(methodName)) {
                    return SpatialConvexHullMethod.class;
                }
                if ("symDifference".equals(methodName)) {
                    return SpatialSymDifferenceMethod.class;
                }
                if ("difference".equals(methodName)) {
                    return SpatialDifferenceMethod.class;
                }
                if ("union".equals(methodName)) {
                    return SpatialUnionMethod.class;
                }
                if ("bboxTest".equals(methodName)) {
                    return SpatialBboxTestMethod2.class;
                }
                if ("getLength".equals(methodName)) {
                    return SpatialLengthMethod.class;
                }
                if ("getNumPoints".equals(methodName)) {
                    return SpatialNumPointsMethod.class;
                }
                if ("getCentroid".equals(methodName)) {
                    return SpatialCentroidMethod.class;
                }
                if ("getArea".equals(methodName)) {
                    return SpatialAreaMethod.class;
                }
                if ("getPointOnSurface".equals(methodName)) {
                    return SpatialPointOnSurfaceMethod.class;
                }
                if ("getNumGeometries".equals(methodName)) {
                    return SpatialNumGeometriesMethod.class;
                }
                if ("getGeometryN".equals(methodName)) {
                    return SpatialGeometryNMethod.class;
                }
                if (isPoint) {
                    if ("getX".equals(methodName)) {
                        return SpatialXMethod.class;
                    }
                    if ("getY".equals(methodName)) {
                        return SpatialYMethod.class;
                    }
                }
                if (isLineString) {
                    if ("isRing".equals(methodName)) {
                        return SpatialIsRingMethod3.class;
                    }
                    if ("isClosed".equals(methodName)) {
                        return SpatialIsClosedMethod.class;
                    }
                    if ("getStartPoint".equals(methodName)) {
                        return SpatialStartPointMethod.class;
                    }
                    if ("getEndPoint".equals(methodName)) {
                        return SpatialEndPointMethod.class;
                    }
                    if ("getPointN".equals(methodName)) {
                        return SpatialPointNMethod.class;
                    }
                }
                if ((isMultiLineString || isLinearRing) && "isClosed".equals(methodName)) {
                    return SpatialIsClosedMethod.class;
                }
                if (isPolygon) {
                    if ("getExteriorRing".equals(methodName)) {
                        return SpatialExteriorRingMethod.class;
                    }
                    if ("getInteriorRingN".equals(methodName)) {
                        return SpatialInteriorRingNMethod.class;
                    }
                    if ("getNumInteriorRing".equals(methodName)) {
                        return SpatialNumInteriorRingMethod.class;
                    }
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }
}

