/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.geom.Line2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class Line2dFloatStringConverter
implements TypeConverter<Line2D.Float, String> {
    private static final long serialVersionUID = -5379075091827141527L;

    public Line2D.Float toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Line2D.Float l = new Line2D.Float();
        StringTokenizer tokeniser = new StringTokenizer(str, ")");
        String token = tokeniser.nextToken();
        token = token.substring(1);
        String xStr = token.substring(0, token.indexOf(","));
        String yStr = token.substring(token.indexOf(",") + 1);
        float x1 = 0.0f;
        try {
            x1 = Float.valueOf(xStr).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Line2D.Float.class.getName()}), (Throwable)nfe);
        }
        float y1 = 0.0f;
        try {
            y1 = Float.valueOf(yStr).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Line2D.Float.class.getName()}), (Throwable)nfe);
        }
        token = tokeniser.nextToken();
        token = token.substring(1);
        xStr = token.substring(0, token.indexOf(","));
        yStr = token.substring(token.indexOf(",") + 1);
        float x2 = 0.0f;
        try {
            x2 = Float.valueOf(xStr).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Line2D.Float.class.getName()}), (Throwable)nfe);
        }
        float y2 = 0.0f;
        try {
            y2 = Float.valueOf(yStr).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Line2D.Float.class.getName()}), (Throwable)nfe);
        }
        l.setLine(x1, y1, x2, y2);
        return l;
    }

    public String toDatastoreType(Line2D.Float line) {
        if (line == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        str.append("(").append(line.x1).append(",").append(line.y1).append("),");
        str.append("(").append(line.x2).append(",").append(line.y2).append(")");
        return str.toString();
    }
}

