/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.LineStringColumnMapping;
import org.postgis.LineString;
import org.postgis.LinearRing;

public class LinearRingColumnMapping
extends LineStringColumnMapping {
    public LinearRingColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    public Object getObject(ResultSet rs, int exprIndex) {
        LineString lineString = (LineString)super.getObject(rs, exprIndex);
        if (lineString == null) {
            return null;
        }
        LinearRing linearRing = new LinearRing(lineString.getPoints());
        linearRing.setSrid(lineString.getSrid());
        return linearRing;
    }

    @Override
    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        LineString lineString = null;
        if (value != null) {
            LinearRing linearRing = (LinearRing)value;
            lineString = new LineString(linearRing.getPoints());
            lineString.setSrid(linearRing.getSrid());
        }
        super.setObject(ps, exprIndex, lineString);
    }
}

