/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.Point;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class PointStringConverter
implements TypeConverter<Point, String> {
    private static final long serialVersionUID = -1868475857358495624L;

    public Point toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Point p = new Point();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        int x = 0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Double.valueOf(token).intValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Point.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        int y = 0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Double.valueOf(token).intValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Point.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        p.setLocation(x, y);
        return p;
    }

    public String toDatastoreType(Point p) {
        return p != null ? "(" + p.getX() + "," + p.getY() + ")" : null;
    }
}

