/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.QuadCurve2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class QuadCurve2dDoubleMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
    }

    public Class getJavaType() {
        return QuadCurve2D.Double.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        QuadCurve2D.Double qc = (QuadCurve2D.Double)value;
        if (index == 0) {
            return qc.getX1();
        }
        if (index == 1) {
            return qc.getY1();
        }
        if (index == 2) {
            return qc.getCtrlX();
        }
        if (index == 3) {
            return qc.getCtrlY();
        }
        if (index == 4) {
            return qc.getX2();
        }
        if (index == 5) {
            return qc.getY2();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        QuadCurve2D line = (QuadCurve2D)value;
        if (line == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getColumnMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getColumnMapping(0).setDouble(ps, exprIndex[0], line.getX1());
            this.getColumnMapping(1).setDouble(ps, exprIndex[1], line.getY1());
            this.getColumnMapping(2).setDouble(ps, exprIndex[2], line.getCtrlX());
            this.getColumnMapping(3).setDouble(ps, exprIndex[3], line.getCtrlY());
            this.getColumnMapping(4).setDouble(ps, exprIndex[4], line.getX2());
            this.getColumnMapping(5).setDouble(ps, exprIndex[5], line.getY2());
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        double x1 = this.getColumnMapping(0).getDouble(resultSet, exprIndex[0]);
        double y1 = this.getColumnMapping(1).getDouble(resultSet, exprIndex[1]);
        double ctrlx = this.getColumnMapping(2).getDouble(resultSet, exprIndex[2]);
        double ctrly = this.getColumnMapping(3).getDouble(resultSet, exprIndex[3]);
        double x2 = this.getColumnMapping(4).getDouble(resultSet, exprIndex[5]);
        double y2 = this.getColumnMapping(5).getDouble(resultSet, exprIndex[6]);
        return new QuadCurve2D.Double(x1, y1, ctrlx, ctrly, x2, y2);
    }
}

