/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.wrappers;

import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.datanucleus.FetchPlanState;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCO;

public class Ellipse2dFloat
extends Ellipse2D.Float
implements SCO<Ellipse2D.Float> {
    private static final long serialVersionUID = -5951938691019092752L;
    protected transient ObjectProvider ownerOP;
    protected transient String fieldName;

    public Ellipse2dFloat(ObjectProvider ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.fieldName = mmd.getName();
    }

    public void initialise(Ellipse2D.Float newValue, Object oldValue) {
        Ellipse2D.Float ellipse = newValue;
        super.setFrame(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
    }

    public void initialise(Ellipse2D.Float value) {
        Ellipse2D.Float ellipse = value;
        super.setFrame(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
    }

    public void initialise() {
    }

    public Ellipse2D.Float getValue() {
        return new Ellipse2D.Float((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight());
    }

    public void unsetOwner() {
        this.ownerOP = null;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.getExecutionContext().getApiAdapter().makeDirty(this.ownerOP.getObject(), this.fieldName);
        }
    }

    public Ellipse2D.Float detachCopy(FetchPlanState state) {
        return new Ellipse2D.Float((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight());
    }

    public void attachCopy(Ellipse2D.Float value) {
        double oldX = this.getX();
        double oldY = this.getY();
        double oldW = this.getWidth();
        double oldH = this.getHeight();
        this.initialise(value, null);
        Ellipse2dFloat rect = (Ellipse2dFloat)value;
        double newX = rect.getX();
        double newY = rect.getY();
        double newW = rect.getWidth();
        double newH = rect.getHeight();
        if (oldX != newX || oldY != newY || oldW != newW || oldH != newH) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((Ellipse2dFloat)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        super.setFrame(x, y, w, h);
        this.makeDirty();
    }

    @Override
    public void setFrame(float x, float y, float w, float h) {
        super.setFrame(x, y, w, h);
        this.makeDirty();
    }

    @Override
    public void setFrame(Point2D loc, Dimension2D size) {
        super.setFrame(loc, size);
        this.makeDirty();
    }

    @Override
    public void setFrame(Rectangle2D r) {
        super.setFrame(r);
        this.makeDirty();
    }

    @Override
    public void setFrameFromDiagonal(double x1, double y1, double x2, double y2) {
        super.setFrameFromDiagonal(x1, y1, x2, y2);
        this.makeDirty();
    }

    @Override
    public void setFrameFromDiagonal(Point2D p1, Point2D p2) {
        super.setFrameFromDiagonal(p1, p2);
        this.makeDirty();
    }

    @Override
    public void setFrameFromCenter(double centerX, double centerY, double cornerX, double cornerY) {
        super.setFrameFromCenter(centerX, centerY, cornerX, cornerY);
        this.makeDirty();
    }

    @Override
    public void setFrameFromCenter(Point2D center, Point2D corner) {
        super.setFrameFromCenter(center, corner);
        this.makeDirty();
    }
}

