/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMethodHelper;

public class SpatialGeometryNMethod2
implements SQLMethod {
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (args == null) {
            throw new NucleusUserException("Cannot invoke Spatial.geometryN without arguments");
        }
        if (expr == null && args.size() != 2) {
            throw new NucleusUserException("Cannot invoke Spatial.geometryN without 2 arguments");
        }
        if (expr != null && args.size() != 1) {
            throw new NucleusUserException("Cannot invoke geom.getGeometryN() without 1 argument");
        }
        SQLExpression geomExpr = expr;
        SQLExpression distExpr = (SQLExpression)args.get(0);
        if (expr == null) {
            geomExpr = (SQLExpression)args.get(0);
            distExpr = (SQLExpression)args.get(1);
        }
        ArrayList<SQLExpression> geomFuncArgs = new ArrayList<SQLExpression>();
        geomFuncArgs.add(geomExpr);
        GeometryExpression geomSdoExpr = new GeometryExpression(stmt, null, "geometry.from_sdo_geom", geomFuncArgs, null);
        ArrayList<GeometryExpression> treatFuncArgs = new ArrayList<GeometryExpression>();
        treatFuncArgs.add(geomSdoExpr);
        ArrayList<String> treatFuncTypeArgs = new ArrayList<String>();
        treatFuncTypeArgs.add("GeometryCollection");
        GeometryExpression treatExpr = new GeometryExpression(stmt, null, "treat", treatFuncArgs, treatFuncTypeArgs);
        ArrayList<SQLExpression> startFuncArgs = new ArrayList<SQLExpression>();
        startFuncArgs.add(treatExpr);
        startFuncArgs.add(distExpr);
        GeometryExpression startExpr = new GeometryExpression(stmt, null, "geometryN", startFuncArgs, null);
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        ArrayList<GeometryExpression> funcArgs = new ArrayList<GeometryExpression>();
        funcArgs.add(startExpr);
        JavaTypeMapping geomMapping = SpatialMethodHelper.getGeometryMapping(clr, geomExpr);
        return new GeometryExpression(stmt, geomMapping, "geometry.get_sdo_geom", funcArgs, null);
    }
}

