/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.RoundRectangle2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class RoundRectangle2dDoubleMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
    }

    public Class getJavaType() {
        return RoundRectangle2D.Double.class;
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        RoundRectangle2D.Double rr = (RoundRectangle2D.Double)value;
        if (index == 0) {
            return rr.getX();
        }
        if (index == 1) {
            return rr.getY();
        }
        if (index == 2) {
            return rr.getWidth();
        }
        if (index == 3) {
            return rr.getHeight();
        }
        if (index == 4) {
            return rr.getArcWidth();
        }
        if (index == 5) {
            return rr.getArcHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        RoundRectangle2D roundRectangle = (RoundRectangle2D)value;
        if (roundRectangle == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getDatastoreMapping(0).setDouble(ps, exprIndex[0], roundRectangle.getX());
            this.getDatastoreMapping(1).setDouble(ps, exprIndex[1], roundRectangle.getY());
            this.getDatastoreMapping(2).setDouble(ps, exprIndex[2], roundRectangle.getWidth());
            this.getDatastoreMapping(3).setDouble(ps, exprIndex[3], roundRectangle.getHeight());
            this.getDatastoreMapping(4).setDouble(ps, exprIndex[4], roundRectangle.getArcWidth());
            this.getDatastoreMapping(5).setDouble(ps, exprIndex[5], roundRectangle.getArcHeight());
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        double x = this.getDatastoreMapping(0).getDouble(resultSet, exprIndex[0]);
        double y = this.getDatastoreMapping(1).getDouble(resultSet, exprIndex[1]);
        double width = this.getDatastoreMapping(2).getDouble(resultSet, exprIndex[2]);
        double height = this.getDatastoreMapping(3).getDouble(resultSet, exprIndex[3]);
        double arcwidth = this.getDatastoreMapping(4).getDouble(resultSet, exprIndex[4]);
        double archeight = this.getDatastoreMapping(5).getDouble(resultSet, exprIndex[5]);
        return new RoundRectangle2D.Double(x, y, width, height, arcwidth, archeight);
    }
}

