/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.adapter;

import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.PostgreSQLAdapter;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.types.geospatial.rdbms.adapter.PostGISTypeInfo;
import org.datanucleus.store.types.geospatial.rdbms.adapter.SpatialRDBMSAdapter;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.GeometryCollectionRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.LineStringRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.MultiPolygonRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.GeometryRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.LinearRingRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.MultiLineStringRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.MultiPointRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.PGbox2dRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.PGbox3dRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.PointRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.PolygonRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxAboveMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxBelowMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxContainsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxLeftMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxOverlapsAboveMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxOverlapsBelowMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxOverlapsLeftMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxOverlapsRightMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxRightMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISBboxWithinMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.PostGISSameAsMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAreaMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAsBinaryMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAsTextMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBboxTestMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBoundaryMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBufferMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialCentroidMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialContainsMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialConvexHullMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialCrossesMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDifferenceMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDimensionMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDisjointMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDistanceMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEndPointMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEnvelopeMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEqualsMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialExteriorRingMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeographyFromTextMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeographyFromWKBMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomFromTextMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomFromWKBMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomTransformMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeometryNMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeometryTypeMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialInteriorRingNMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIntersectionMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIntersectsMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsClosedMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsEmptyMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsRingMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsSimpleMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialLengthMethod4;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumGeometriesMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumInteriorRingMethod4;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumPointsMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialOverlapsMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointNMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointOnSurfaceMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialRelateMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialSridMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialStartPointMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialSymDifferenceMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialTouchesMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialUnionMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialWithinMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialXMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialYMethod3;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.Point;

public class PostGISAdapter
extends PostgreSQLAdapter
implements SpatialRDBMSAdapter {
    public static final String HAS_MEASURE_EXTENSION_KEY = "postgis-hasMeasure";

    public PostGISAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.remove("PrimaryKeyInCreateStatements");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        PostGISTypeInfo sqlType = PostGISTypeInfo.TYPEINFO_PROTOTYPE;
        this.addSQLTypeForJDBCType(handler, mconn, (short)1111, sqlType, true);
    }

    protected void loadDatastoreMappings(PluginManager mgr, ClassLoaderResolver clr) {
        Class cls;
        try {
            cls = clr.classForName("com.vividsolutions.jts.geom.Geometry");
            if (cls != null) {
                this.registerDatastoreMapping(com.vividsolutions.jts.geom.Geometry.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.GeometryRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(com.vividsolutions.jts.geom.GeometryCollection.class.getName(), GeometryCollectionRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(LinearRing.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.LinearRingRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(com.vividsolutions.jts.geom.LineString.class.getName(), LineStringRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(MultiLineString.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.MultiLineStringRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(MultiPolygon.class.getName(), MultiPolygonRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(MultiPoint.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.MultiPointRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(com.vividsolutions.jts.geom.Point.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.PointRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(Polygon.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.jts2postgis.PolygonRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
            }
        }
        catch (Throwable thr) {
            NucleusLogger.DATASTORE.warn((Object)"Not loading RDBMS support for Vividsolutions JTS types since not present");
        }
        try {
            cls = clr.classForName("org.postgis.Geometry");
            if (cls != null) {
                this.registerDatastoreMapping(Geometry.class.getName(), GeometryRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(GeometryCollection.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.GeometryCollectionRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(org.postgis.LinearRing.class.getName(), LinearRingRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(LineString.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.LineStringRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(org.postgis.MultiLineString.class.getName(), MultiLineStringRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(org.postgis.MultiPolygon.class.getName(), org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis.MultiPolygonRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(org.postgis.MultiPoint.class.getName(), MultiPointRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(Point.class.getName(), PointRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(org.postgis.Polygon.class.getName(), PolygonRDBMSMapping.class, JDBCType.OTHER, "geometry", true);
                this.registerDatastoreMapping(PGbox2d.class.getName(), PGbox2dRDBMSMapping.class, JDBCType.OTHER, "box2d", true);
                this.registerDatastoreMapping(PGbox3d.class.getName(), PGbox3dRDBMSMapping.class, JDBCType.OTHER, "box3d", true);
            }
        }
        catch (Throwable thr) {
            NucleusLogger.DATASTORE.warn((Object)"Not loading RDBMS support for PostGIS types since not present");
        }
        super.loadDatastoreMappings(mgr, clr);
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return "ALTER TABLE " + pk.getTable().toString() + " ADD " + pk;
    }

    public String getAddColumnStatement(Table table, Column column) {
        if (this.isGeometryColumn(column)) {
            return this.getAddGeometryColumnStatement(table, column);
        }
        return super.getAddColumnStatement(table, column);
    }

    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props, IdentifierFactory factory) {
        boolean hasGeometryColumn = false;
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isGeometryColumn(columns[i])) continue;
            hasGeometryColumn = true;
            break;
        }
        if (!hasGeometryColumn) {
            return super.getCreateTableStatement(table, columns, null, factory);
        }
        StringBuilder createStatements = new StringBuilder();
        createStatements.append("CREATE TABLE ").append(table.toString()).append(" ();").append(this.getContinuationString());
        for (Column col : columns) {
            String stmt = this.getAddColumnStatement((Table)table, col);
            createStatements.append(stmt).append(";").append(this.getContinuationString());
        }
        return createStatements.toString();
    }

    @Override
    public String getRetrieveCrsWktStatement(Table table, int srid) {
        return "SELECT srtext FROM #schema . spatial_ref_sys WHERE srid = #srid".replace("#schema", table.getSchemaName()).replace("#srid", "" + srid);
    }

    @Override
    public String getRetrieveCrsNameStatement(Table table, int srid) {
        return "SELECT auth_name || ':' || auth_srid FROM #schema . spatial_ref_sys WHERE srid = #srid".replace("#schema", table.getSchemaName()).replace("#srid", "" + srid);
    }

    @Override
    public String getCalculateBoundsStatement(Table table, Column column) {
        return "SELECT min(xmin(box2d(#column))), min(ymin(box2d(#column))), max(xmax(box2d(#column))), max(ymax(box2d(#column)))" + "FROM #schema . #table".replace("#schema", table.getSchemaName()).replace("#table", "" + table.getIdentifier().getName()).replace("#column", "" + column.getIdentifier().getName());
    }

    private String getAddGeometryColumnStatement(Table table, Column column) {
        int srid = -1;
        int dimension = 2;
        boolean hasMeasure = false;
        String extensionValue = MetaDataUtils.getValueForExtensionRecursively((MetaData)column.getColumnMetaData(), (String)"spatial-srid");
        if (extensionValue != null) {
            try {
                srid = Integer.parseInt(extensionValue);
            }
            catch (NumberFormatException nfe) {
                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"RDBMS.Adapter.InvalidExtensionValue", (Object[])new Object[]{"spatial-srid", extensionValue}), (Throwable)nfe);
            }
        }
        if ((extensionValue = MetaDataUtils.getValueForExtensionRecursively((MetaData)column.getColumnMetaData(), (String)"spatial-dimension")) != null) {
            try {
                dimension = Byte.parseByte(extensionValue);
            }
            catch (NumberFormatException nfe) {
                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"RDBMS.Adapter.InvalidExtensionValue", (Object[])new Object[]{"spatial-dimension", extensionValue}), (Throwable)nfe);
            }
        }
        if ((extensionValue = MetaDataUtils.getValueForExtensionRecursively((MetaData)column.getColumnMetaData(), (String)HAS_MEASURE_EXTENSION_KEY)) != null) {
            try {
                hasMeasure = Boolean.parseBoolean(extensionValue);
            }
            catch (NumberFormatException nfe) {
                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"RDBMS.Adapter.InvalidExtensionValue", (Object[])new Object[]{HAS_MEASURE_EXTENSION_KEY, extensionValue}), (Throwable)nfe);
            }
        }
        if (hasMeasure) {
            dimension = (byte)(dimension + 1);
        }
        return "SELECT AddGeometryColumn( '#schema', '#table', '#column', #srid, '#type', #dimension )".replace("#schema", table.getSchemaName() == null ? "" : table.getSchemaName()).replace("#table", table.getIdentifier().getName()).replace("#column", column.getIdentifier().getName()).replace("#srid", "" + srid).replace("#type", column.getTypeInfo().getLocalTypeName().concat(hasMeasure ? "M" : "")).replace("#dimension", "" + dimension);
    }

    @Override
    public boolean isGeometryColumn(Column column) {
        SQLTypeInfo typeInfo = column.getTypeInfo();
        return typeInfo == null ? false : typeInfo.getTypeName().equalsIgnoreCase("geometry");
    }

    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("PostGIS.bboxBelow".equals(methodName)) {
                return PostGISBboxBelowMethod.class;
            }
            if ("PostGIS.bboxAbove".equals(methodName)) {
                return PostGISBboxAboveMethod.class;
            }
            if ("PostGIS.bboxLeft".equals(methodName)) {
                return PostGISBboxLeftMethod.class;
            }
            if ("PostGIS.bboxRight".equals(methodName)) {
                return PostGISBboxRightMethod.class;
            }
            if ("PostGIS.bboxOverlapsBelow".equals(methodName)) {
                return PostGISBboxOverlapsBelowMethod.class;
            }
            if ("PostGIS.bboxOverlapsAbove".equals(methodName)) {
                return PostGISBboxOverlapsAboveMethod.class;
            }
            if ("PostGIS.bboxOverlapsLeft".equals(methodName)) {
                return PostGISBboxOverlapsLeftMethod.class;
            }
            if ("PostGIS.bboxOverlapsRight".equals(methodName)) {
                return PostGISBboxOverlapsRightMethod.class;
            }
            if ("PostGIS.bboxContains".equals(methodName)) {
                return PostGISBboxContainsMethod.class;
            }
            if ("PostGIS.bboxWithin".equals(methodName)) {
                return PostGISBboxWithinMethod.class;
            }
            if ("PostGIS.sameAs".equals(methodName)) {
                return PostGISSameAsMethod.class;
            }
            if ("Spatial.bboxTest".equals(methodName)) {
                return SpatialBboxTestMethod.class;
            }
            if ("Spatial.dimension".equals(methodName)) {
                return SpatialDimensionMethod3.class;
            }
            if ("Spatial.srid".equals(methodName)) {
                return SpatialSridMethod3.class;
            }
            if ("Spatial.x".equals(methodName)) {
                return SpatialXMethod3.class;
            }
            if ("Spatial.y".equals(methodName)) {
                return SpatialYMethod3.class;
            }
            if ("Spatial.area".equals(methodName)) {
                return SpatialAreaMethod3.class;
            }
            if ("Spatial.length".equals(methodName)) {
                return SpatialLengthMethod4.class;
            }
            if ("Spatial.distance".equals(methodName)) {
                return SpatialDistanceMethod3.class;
            }
            if ("Spatial.numPoints".equals(methodName)) {
                return SpatialNumPointsMethod3.class;
            }
            if ("Spatial.numInteriorRing".equals(methodName)) {
                return SpatialNumInteriorRingMethod4.class;
            }
            if ("Spatial.numGeometries".equals(methodName)) {
                return SpatialNumGeometriesMethod3.class;
            }
            if ("Spatial.asBinary".equals(methodName)) {
                return SpatialAsBinaryMethod3.class;
            }
            if ("Spatial.asText".equals(methodName)) {
                return SpatialAsTextMethod3.class;
            }
            if ("Spatial.geogFromText".equals(methodName)) {
                return SpatialGeographyFromTextMethod.class;
            }
            if ("Spatial.geometryType".equals(methodName)) {
                return SpatialGeometryTypeMethod3.class;
            }
            if ("Spatial.geomFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.pointFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.lineFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.polyFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.mLineFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.mPointFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.mPolyFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.geomCollFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod3.class;
            }
            if ("Spatial.envelope".equals(methodName)) {
                return SpatialEnvelopeMethod3.class;
            }
            if ("Spatial.boundary".equals(methodName)) {
                return SpatialBoundaryMethod3.class;
            }
            if ("Spatial.convexHull".equals(methodName)) {
                return SpatialConvexHullMethod3.class;
            }
            if ("Spatial.startPoint".equals(methodName)) {
                return SpatialStartPointMethod3.class;
            }
            if ("Spatial.endPoint".equals(methodName)) {
                return SpatialEndPointMethod3.class;
            }
            if ("Spatial.centroid".equals(methodName)) {
                return SpatialCentroidMethod3.class;
            }
            if ("Spatial.pointOnSurface".equals(methodName)) {
                return SpatialPointOnSurfaceMethod3.class;
            }
            if ("Spatial.exteriorRing".equals(methodName)) {
                return SpatialExteriorRingMethod3.class;
            }
            if ("Spatial.equals".equals(methodName)) {
                return SpatialEqualsMethod3.class;
            }
            if ("Spatial.disjoint".equals(methodName)) {
                return SpatialDisjointMethod3.class;
            }
            if ("Spatial.intersects".equals(methodName)) {
                return SpatialIntersectsMethod3.class;
            }
            if ("Spatial.touches".equals(methodName)) {
                return SpatialTouchesMethod3.class;
            }
            if ("Spatial.crosses".equals(methodName)) {
                return SpatialCrossesMethod3.class;
            }
            if ("Spatial.within".equals(methodName)) {
                return SpatialWithinMethod3.class;
            }
            if ("Spatial.contains".equals(methodName)) {
                return SpatialContainsMethod3.class;
            }
            if ("Spatial.overlaps".equals(methodName)) {
                return SpatialOverlapsMethod3.class;
            }
            if ("Spatial.relate".equals(methodName)) {
                return SpatialRelateMethod3.class;
            }
            if ("Spatial.isClosed".equals(methodName)) {
                return SpatialIsClosedMethod3.class;
            }
            if ("Spatial.isEmpty".equals(methodName)) {
                return SpatialIsEmptyMethod3.class;
            }
            if ("Spatial.isRing".equals(methodName)) {
                return SpatialIsRingMethod3.class;
            }
            if ("Spatial.isSimple".equals(methodName)) {
                return SpatialIsSimpleMethod3.class;
            }
            if ("Spatial.buffer".equals(methodName)) {
                return SpatialBufferMethod3.class;
            }
            if ("Spatial.difference".equals(methodName)) {
                return SpatialDifferenceMethod3.class;
            }
            if ("Spatial.intersection".equals(methodName)) {
                return SpatialIntersectionMethod3.class;
            }
            if ("Spatial.union".equals(methodName)) {
                return SpatialUnionMethod3.class;
            }
            if ("Spatial.symDifference".equals(methodName)) {
                return SpatialSymDifferenceMethod3.class;
            }
            if ("Spatial.interiorRingN".equals(methodName)) {
                return SpatialInteriorRingNMethod3.class;
            }
            if ("Spatial.pointN".equals(methodName)) {
                return SpatialPointNMethod3.class;
            }
            if ("Spatial.geogFromWKB".equals(methodName)) {
                return SpatialGeographyFromWKBMethod.class;
            }
            if ("Spatial.geometryN".equals(methodName)) {
                return SpatialGeometryNMethod3.class;
            }
            if ("Spatial.transform".equals(methodName)) {
                return SpatialGeomTransformMethod.class;
            }
            if ("Spatial.geomFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
            if ("Spatial.geomCollFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
            if ("Spatial.pointFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
            if ("Spatial.mPointFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
            if ("Spatial.lineFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
            if ("Spatial.mLineFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
            if ("Spatial.polyFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
            if ("Spatial.mPolyFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod3.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("com.vividsolutions.jts.geom.Point".equals(className) || cls != null && com.vividsolutions.jts.geom.Point.class.isAssignableFrom(cls)) {
                if ("getX".equals(methodName)) {
                    return SpatialXMethod3.class;
                }
                if ("getY".equals(methodName)) {
                    return SpatialYMethod3.class;
                }
            }
            if ("com.vividsolutions.jts.geom.Geometry".equals(className) || cls != null && com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(cls)) {
                if ("getNumPoints".equals(methodName)) {
                    return SpatialNumPointsMethod3.class;
                }
                if ("getArea".equals(methodName)) {
                    return SpatialAreaMethod3.class;
                }
                if ("contains".equals(methodName)) {
                    return SpatialContainsMethod3.class;
                }
                if ("getEnvelope".equals(methodName)) {
                    return SpatialEnvelopeMethod3.class;
                }
                if ("getDimension".equals(methodName)) {
                    return SpatialDimensionMethod3.class;
                }
                if ("getLength".equals(methodName)) {
                    return SpatialLengthMethod4.class;
                }
                if ("getBoundary".equals(methodName)) {
                    return SpatialBoundaryMethod3.class;
                }
                if ("getSRID".equals(methodName)) {
                    return SpatialSridMethod3.class;
                }
                if ("isSimple".equals(methodName)) {
                    return SpatialIsSimpleMethod3.class;
                }
                if ("isEmpty".equals(methodName)) {
                    return SpatialIsEmptyMethod3.class;
                }
                if ("overlaps".equals(methodName)) {
                    return SpatialOverlapsMethod3.class;
                }
                if ("touches".equals(methodName)) {
                    return SpatialTouchesMethod3.class;
                }
                if ("crosses".equals(methodName)) {
                    return SpatialCrossesMethod3.class;
                }
                if ("within".equals(methodName)) {
                    return SpatialWithinMethod3.class;
                }
                if ("intersects".equals(methodName)) {
                    return SpatialIntersectsMethod3.class;
                }
                if ("intersection".equals(methodName)) {
                    return SpatialIntersectionMethod3.class;
                }
                if ("equals".equals(methodName)) {
                    return SpatialEqualsMethod3.class;
                }
                if ("disjoint".equals(methodName)) {
                    return SpatialDisjointMethod3.class;
                }
                if ("relate".equals(methodName)) {
                    return SpatialRelateMethod3.class;
                }
                if ("difference".equals(methodName)) {
                    return SpatialDifferenceMethod3.class;
                }
                if ("symDifference".equals(methodName)) {
                    return SpatialSymDifferenceMethod3.class;
                }
                if ("getCentroid".equals(methodName)) {
                    return SpatialCentroidMethod3.class;
                }
                if ("toText".equals(methodName)) {
                    return SpatialAsTextMethod3.class;
                }
                if ("union".equals(methodName)) {
                    return SpatialUnionMethod3.class;
                }
                if ("getGeometryType".equals(methodName)) {
                    return SpatialGeometryTypeMethod3.class;
                }
                if ("distance".equals(methodName)) {
                    return SpatialDistanceMethod3.class;
                }
                if ("buffer".equals(methodName)) {
                    return SpatialBufferMethod3.class;
                }
                if ("convexHull".equals(methodName)) {
                    return SpatialConvexHullMethod3.class;
                }
            }
            if ("com.vividsolutions.jts.geom.LineString".equals(className) || cls != null && com.vividsolutions.jts.geom.LineString.class.isAssignableFrom(cls)) {
                if ("isRing".equals(methodName)) {
                    return SpatialIsRingMethod3.class;
                }
                if ("isClosed".equals(methodName)) {
                    return SpatialIsClosedMethod3.class;
                }
                if ("getStartPoint".equals(methodName)) {
                    return SpatialStartPointMethod3.class;
                }
                if ("getEndPoint".equals(methodName)) {
                    return SpatialEndPointMethod3.class;
                }
                if ("getPointN".equals(methodName)) {
                    return SpatialPointNMethod3.class;
                }
            }
            if ("com.vividsolutions.jts.geom.Polygon".equals(className) || cls != null && Polygon.class.isAssignableFrom(cls)) {
                if ("getExteriorRing".equals(methodName)) {
                    return SpatialExteriorRingMethod3.class;
                }
                if ("getInteriorRingN".equals(methodName)) {
                    return SpatialInteriorRingNMethod3.class;
                }
                if ("getNumInteriorRing".equals(methodName)) {
                    return SpatialNumInteriorRingMethod4.class;
                }
            }
            if ("com.vividsolutions.jts.geom.GeometryCollection".equals(className) || cls != null && com.vividsolutions.jts.geom.GeometryCollection.class.isAssignableFrom(cls)) {
                if ("getNumGeometries".equals(methodName)) {
                    return SpatialNumGeometriesMethod3.class;
                }
                if ("getGeometryN".equals(methodName)) {
                    return SpatialGeometryNMethod3.class;
                }
            }
            if ("org.postgis.Point".equals(className) || cls != null && Point.class.isAssignableFrom(cls)) {
                if ("getX".equals(methodName)) {
                    return SpatialXMethod3.class;
                }
                if ("getY".equals(methodName)) {
                    return SpatialYMethod3.class;
                }
            }
            if ("org.postgis.Geometry".equals(className) || cls != null && Geometry.class.isAssignableFrom(cls)) {
                if ("numPoints".equals(methodName)) {
                    return SpatialNumPointsMethod3.class;
                }
                if ("getDimension".equals(methodName)) {
                    return SpatialDimensionMethod3.class;
                }
                if ("getSrid".equals(methodName)) {
                    return SpatialSridMethod3.class;
                }
                if ("equals".equals(methodName)) {
                    return SpatialEqualsMethod3.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.types.geospatial.rdbms.adapter.Localisation_PostGIS", (ClassLoader)PostGISAdapter.class.getClassLoader());
    }
}

