/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMethodHelper;

public class SpatialInteriorRingNMethod3
implements SQLMethod {
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (args == null) {
            throw new NucleusUserException("Cannot invoke Spatial.interiorRingN without arguments");
        }
        if (expr == null && args.size() != 2) {
            throw new NucleusUserException("Cannot invoke Spatial.interiorRingN without 2 arguments");
        }
        if (expr != null && args.size() != 1) {
            throw new NucleusUserException("Cannot invoke geom.getInteriorRingN() without 1 argument");
        }
        SQLExpression geomExpr = expr;
        SQLExpression distExpr = expr;
        if (expr == null) {
            geomExpr = (SQLExpression)args.get(0);
            distExpr = (SQLExpression)args.get(1);
        } else {
            geomExpr = expr;
            distExpr = (SQLExpression)args.get(0);
        }
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(geomExpr);
        funcArgs.add(distExpr);
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        JavaTypeMapping geomMapping = SpatialMethodHelper.getGeometryMapping(clr, geomExpr);
        return new GeometryExpression(stmt, geomMapping, "st_interiorringn", funcArgs, null);
    }
}

