/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.adapter;

import java.sql.DatabaseMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.OracleAdapter;
import org.datanucleus.store.rdbms.adapter.OracleTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.types.geospatial.rdbms.adapter.SpatialRDBMSAdapter;

public class OracleSpatialAdapter
extends OracleAdapter
implements SpatialRDBMSAdapter {
    public OracleSpatialAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        OracleTypeInfo sqlType = new OracleTypeInfo("SDO_GEOMETRY", 2002, 0, null, null, null, 1, false, 0, false, false, false, "SDO_GEOMETRY", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-123, (SQLTypeInfo)sqlType, true);
    }

    @Override
    public boolean isGeometryColumn(Column c) {
        return String.valueOf(c.getTypeInfo().getDataType()).matches("[2-4][0,3,4][0-9][0-9]");
    }

    @Override
    public String getRetrieveCrsNameStatement(Table table, int srid) {
        return "SELECT CS_NAME FROM MDSYS.CS_SRS WHERE SRID = #srid".replace("#srid", "" + srid);
    }

    @Override
    public String getRetrieveCrsWktStatement(Table table, int srid) {
        return "SELECT WKTEXT FROM MDSYS.CS_SRS WHERE SRID = #srid".replace("#srid", "" + srid);
    }

    @Override
    public String getCalculateBoundsStatement(Table table, Column column) {
        return "SELECT SDO_GEOM.SDO_MIN_MBR_ORDINATE(SDO_AGGR_MBR(#column), 1), SDO_GEOM.SDO_MIN_MBR_ORDINATE(SDO_AGGR_MBR(#column), 2), SDO_GEOM.SDO_MAX_MBR_ORDINATE(SDO_AGGR_MBR(#column), 1), SDO_GEOM.SDO_MAX_MBR_ORDINATE(SDO_AGGR_MBR(#column), 2) " + "FROM #table".replace("#column", column.getIdentifier().getName()).replace("#table", table.getIdentifier().getName());
    }
}

