/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMethodHelper;

public class SpatialBoundaryMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr == null && (args == null || args.size() != 1)) {
            throw new NucleusUserException("Cannot invoke Spatial.boundary without 1 argument");
        }
        if (expr != null && args != null && args.size() != 0) {
            throw new NucleusUserException("Cannot invoke geom.getBoundary() with an argument");
        }
        SQLExpression argExpr = expr;
        if (expr == null) {
            argExpr = (SQLExpression)args.get(0);
        }
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(argExpr);
        JavaTypeMapping geomMapping = SpatialMethodHelper.getGeometryMapping(this.clr, argExpr);
        return new GeometryExpression(this.stmt, geomMapping, "Boundary", funcArgs, null);
    }
}

