/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;

public class OracleSdoElemInfoArrayMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression ignore, List args) {
        if (args == null || args.size() != 1) {
            throw new NucleusUserException("Cannot invoke Oracle.sdo_elem_info_array without 1 argument");
        }
        SQLExpression numbersExpr = (SQLExpression)args.get(0);
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        if (numbersExpr instanceof StringLiteral) {
            JavaTypeMapping m = this.getMappingForClass(Integer.class);
            String[] token = ((String)((StringLiteral)numbersExpr).getValue()).split(",");
            try {
                for (int i = 0; i < token.length; ++i) {
                    SQLExpression numberLit = this.exprFactory.newLiteral(this.stmt, m, (Object)Integer.valueOf(token[i]));
                    funcArgs.add(numberLit);
                }
            }
            catch (NumberFormatException e) {
                throw new NucleusUserException("Impossible to convert input to Oracle.sdo_elem_info_array into list of integers");
            }
        }
        return new GeometryExpression(this.stmt, null, "SDO_ELEM_INFO_ARRAY", funcArgs, null);
    }
}

