/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.mysql;

import java.sql.SQLException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;

public abstract class MySQLSpatialRDBMSMapping
extends AbstractDatastoreMapping {
    protected static final int SRID_LENGTH = 4;
    private static final byte XDR = 0;
    private static final byte NDR = 1;

    public MySQLSpatialRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    protected void initialize() {
        this.initTypeInfo();
    }

    protected byte[] mysqlBinaryToWkb(byte[] mysqlBinary) throws SQLException {
        byte[] wkb = new byte[mysqlBinary.length - 4];
        System.arraycopy(mysqlBinary, 4, wkb, 0, wkb.length);
        return wkb;
    }

    protected int mysqlBinaryToSrid(byte[] mysqlBinary) throws SQLException {
        if (this.isBigEndian(mysqlBinary[4])) {
            return mysqlBinary[0] << 24 | (mysqlBinary[1] & 0xFF) << 16 | (mysqlBinary[2] & 0xFF) << 8 | mysqlBinary[3] & 0xFF;
        }
        return mysqlBinary[3] << 24 | (mysqlBinary[2] & 0xFF) << 16 | (mysqlBinary[1] & 0xFF) << 8 | mysqlBinary[0] & 0xFF;
    }

    protected byte[] wkbToMysqlBinary(byte[] wkb, int srid) throws SQLException {
        byte[] mysqlBinary = new byte[wkb.length + 4];
        if (this.isBigEndian(wkb[0])) {
            mysqlBinary[0] = (byte)(srid >> 24);
            mysqlBinary[1] = (byte)(srid >> 16);
            mysqlBinary[2] = (byte)(srid >> 8);
            mysqlBinary[3] = (byte)srid;
        } else {
            mysqlBinary[3] = (byte)(srid >> 24);
            mysqlBinary[2] = (byte)(srid >> 16);
            mysqlBinary[1] = (byte)(srid >> 8);
            mysqlBinary[0] = (byte)srid;
        }
        System.arraycopy(wkb, 0, mysqlBinary, 4, wkb.length);
        return mysqlBinary;
    }

    private boolean isBigEndian(byte flag) throws SQLException {
        if (flag == 0) {
            return true;
        }
        if (flag == 1) {
            return false;
        }
        throw new SQLException("Unknown Endian type:" + flag);
    }
}

