/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.wrappers;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCO;

public class Line2dFloat
extends Line2D.Float
implements SCO {
    private static final long serialVersionUID = 7554204283366263638L;
    protected transient ObjectProvider ownerOP;
    protected transient String fieldName;

    public Line2dFloat(ObjectProvider ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.fieldName = mmd.getName();
    }

    public void initialise(Object value, boolean forInsert, boolean forUpdate) throws ClassCastException {
        super.setLine((Line2D.Float)value);
    }

    public void initialise() {
    }

    public Object getValue() {
        return new Line2D.Float((float)this.getX1(), (float)this.getY1(), (float)this.getX2(), (float)this.getY2());
    }

    public void unsetOwner() {
        this.ownerOP = null;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.getExecutionContext().getApiAdapter().makeDirty(this.ownerOP.getObject(), this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        return new Line2D.Float((float)this.getX1(), (float)this.getY1(), (float)this.getX2(), (float)this.getY2());
    }

    public void attachCopy(Object value) {
        double oldX1 = this.getX1();
        double oldY1 = this.getY1();
        double oldX2 = this.getX2();
        double oldY2 = this.getY2();
        this.initialise(value, false, true);
        Line2dFloat rect = (Line2dFloat)value;
        double newX1 = rect.getX1();
        double newY1 = rect.getY1();
        double newX2 = rect.getX2();
        double newY2 = rect.getY2();
        if (oldX1 != newX1 || oldY1 != newY1 || oldX2 != newX2 || oldY2 != newY2) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((Line2dFloat)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setLine(float x1, float y1, float x2, float y2) {
        super.setLine(x1, y1, x2, y2);
        this.makeDirty();
    }

    @Override
    public void setLine(Point2D p1, Point2D p2) {
        super.setLine(p1, p2);
        this.makeDirty();
    }

    @Override
    public void setLine(Line2D l) {
        super.setLine(l);
        this.makeDirty();
    }
}

