/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.wrappers;

import java.awt.geom.Point2D;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCO;

public class Point2dFloat
extends Point2D.Float
implements SCO {
    protected transient ObjectProvider ownerOP;
    protected transient String fieldName;

    public Point2dFloat(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerOP;
        this.fieldName = mmd.getName();
    }

    public void initialise(Object value, boolean forInsert, boolean forUpdate) throws ClassCastException {
        super.setLocation((Point2D.Float)value);
    }

    public void initialise() {
    }

    public Object getValue() {
        return new Point2D.Float((float)this.getX(), (float)this.getY());
    }

    public void unsetOwner() {
        this.ownerOP = null;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.getExecutionContext().getApiAdapter().makeDirty(this.ownerOP.getObject(), this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        return new Point2D.Float((float)this.getX(), (float)this.getY());
    }

    public void attachCopy(Object value) {
        double oldX = this.getX();
        double oldY = this.getY();
        this.initialise(value, false, true);
        Point2dFloat rect = (Point2dFloat)value;
        double newX = rect.getX();
        double newY = rect.getY();
        if (oldX != newX || oldY != newY) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((Point2dFloat)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setLocation(float x, float y) {
        super.setLocation(x, y);
        this.makeDirty();
    }

    @Override
    public void setLocation(Point2D p) {
        super.setLocation(p);
        this.makeDirty();
    }
}

