/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class Rectangle2dDoubleStringConverter
implements TypeConverter<Rectangle2D.Double, String> {
    public Rectangle2D.Double toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Rectangle2D.Double r = new Rectangle2D.Double();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        double x = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Double.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        double y = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Double.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        double width = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                width = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Double.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        double height = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                height = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Double.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        r.setRect(x, y, width, height);
        return r;
    }

    public String toDatastoreType(Rectangle2D.Double rect) {
        return rect != null ? "(" + rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight() + ")" : null;
    }
}

