/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo.spatial;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.jdo.JDOCanRetryException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.SpatialRDBMSAdapter;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;

public class SpatialHelper {
    protected JDOPersistenceManagerFactory pmf;
    protected RDBMSStoreManager storeMgr;

    public SpatialHelper(JDOPersistenceManagerFactory pmf) {
        if (pmf == null || pmf.isClosed()) {
            throw new IllegalArgumentException("pmf is null or closed. pmf = " + pmf);
        }
        this.pmf = pmf;
        this.storeMgr = (RDBMSStoreManager)pmf.getNucleusContext().getStoreManager();
    }

    public Integer getSridFromJdoMetadata(Class pc, String fieldName) {
        return this.getIntegerFromJdoMetadata(pc, fieldName, "spatial-srid");
    }

    public Integer getDimensionFromJdoMetadata(Class pc, String fieldName) {
        return this.getIntegerFromJdoMetadata(pc, fieldName, "spatial-dimension");
    }

    public Integer getSridFromDatastoreMetadata(final Class pc, final String fieldName, final PersistenceManager pm) {
        this.checkValid(pc, fieldName);
        Integer srid = (Integer)new QueryExecutor(pm.currentTransaction()){

            @Override
            Query getQuery() {
                Query q = pm.newQuery(pc);
                q.setResult("Spatial.sridFromMetadata( " + fieldName + " )");
                q.setUnique(true);
                q.setRange(0L, 1L);
                return q;
            }
        }.execute();
        return srid;
    }

    public Rectangle2D estimateBoundsFromDatastoreMetadata(final Class pc, final String fieldName, final PersistenceManager pm) {
        this.checkValid(pc, fieldName);
        Rectangle2D bounds = null;
        try {
            bounds = (Rectangle2D)new QueryExecutor(pm.currentTransaction()){

                @Override
                Query getQuery() {
                    Query q = pm.newQuery(pc);
                    q.setResult("Spatial.rectangle2DFromMetadata( " + fieldName + " )");
                    q.setUnique(true);
                    q.setRange(0L, 1L);
                    return q;
                }
            }.execute();
        }
        catch (JDOCanRetryException e) {
            NucleusLogger.QUERY.info((Object)"estimateBoundsFromDatastoreMetadata() failed", (Throwable)e);
        }
        return bounds;
    }

    public Rectangle2D calculateBoundsInDatastore(Class pc, String fieldName, final PersistenceManager pm) {
        this.checkValid(pc, fieldName);
        Table table = this.getTable(pc);
        Column column = this.getColumn(pc, fieldName);
        final String stmt = this.getAdapter().getCalculateBoundsStatement(table, column);
        if (stmt == null) {
            return null;
        }
        Rectangle2D bounds = (Rectangle2D)new QueryExecutor(pm.currentTransaction()){

            @Override
            Query getQuery() {
                Query q = pm.newQuery("javax.jdo.query.SQL", (Object)stmt);
                q.setResultClass(String.class);
                q.setUnique(true);
                return q;
            }
        }.execute();
        return bounds;
    }

    public String getCrsWktForSrid(Class pc, int srid, final PersistenceManager pm) {
        Table table = this.getTable(pc);
        final String stmt = this.getAdapter().getRetrieveCrsWktStatement(table, srid);
        if (stmt == null) {
            return null;
        }
        String crsWKT = (String)new QueryExecutor(pm.currentTransaction()){

            @Override
            Query getQuery() {
                Query q = pm.newQuery("javax.jdo.query.SQL", (Object)stmt);
                q.setResultClass(String.class);
                q.setUnique(true);
                return q;
            }
        }.execute();
        return crsWKT;
    }

    public String getCrsNameForSrid(Class pc, int srid, final PersistenceManager pm) {
        Table table = this.getTable(pc);
        final String stmt = this.getAdapter().getRetrieveCrsNameStatement(table, srid);
        if (stmt == null) {
            return null;
        }
        String crsName = (String)new QueryExecutor(pm.currentTransaction()){

            @Override
            Query getQuery() {
                Query q = pm.newQuery("javax.jdo.query.SQL", (Object)stmt);
                q.setResultClass(String.class);
                q.setUnique(true);
                return q;
            }
        }.execute();
        return crsName;
    }

    protected Integer getIntegerFromJdoMetadata(Class pc, String fieldName, String extensionKey) {
        String value = this.getValueFromJdoMetadata(pc, fieldName, extensionKey);
        Integer integer = null;
        try {
            integer = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return integer;
    }

    protected String getValueFromJdoMetadata(Class pc, String memberName, String extensionKey) {
        this.checkValid(pc, memberName);
        AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(pc, this.storeMgr.getNucleusContext().getClassLoaderResolver(null));
        AbstractMemberMetaData fmd = cmd != null ? cmd.getMetaDataForMember(memberName) : null;
        String value = MetaDataUtils.getValueForExtensionRecursively((MetaData)fmd, (String)extensionKey);
        if (value == null || value.trim().equals("")) {
            return null;
        }
        return value;
    }

    public String[] getGeometryColumnBackedFields(Class pc) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        AbstractMemberMetaData[] fieldMetaData = this.getMetaDataManager().getMetaDataForClass(pc, null).getManagedMembers();
        for (int i = 0; i < fieldMetaData.length; ++i) {
            Column c = this.getColumn(pc, fieldMetaData[i]);
            if (!this.isGeometryColumnBackedField(c)) continue;
            fieldNames.add(fieldMetaData[i].getName());
        }
        return fieldNames.toArray(new String[0]);
    }

    public boolean isGeometryColumnBackedField(Class pc, String fieldName) {
        Column c = this.getColumn(pc, fieldName);
        return this.isGeometryColumnBackedField(c);
    }

    protected boolean isGeometryColumnBackedField(Column c) {
        return this.getAdapter().isGeometryColumn(c);
    }

    protected Table getTable(Class pc) {
        ClassLoaderResolver clr = this.pmf.getNucleusContext().getClassLoaderResolver(this.getClass().getClassLoader());
        return this.storeMgr.getDatastoreClass(pc.getName(), clr);
    }

    protected Column getColumn(Class pc, String fieldName) {
        ClassLoaderResolver clr = this.pmf.getNucleusContext().getClassLoaderResolver(this.getClass().getClassLoader());
        return this.storeMgr.getDatastoreClass(pc.getName(), clr).getMemberMapping(fieldName).getDatastoreMappings()[0].getColumn();
    }

    protected Column getColumn(Class pc, AbstractMemberMetaData mmd) {
        ClassLoaderResolver clr = this.pmf.getNucleusContext().getClassLoaderResolver(this.getClass().getClassLoader());
        return this.storeMgr.getDatastoreClass(pc.getName(), clr).getMemberMapping(mmd).getDatastoreMappings()[0].getColumn();
    }

    protected SpatialRDBMSAdapter getAdapter() throws ClassCastException {
        return (SpatialRDBMSAdapter)this.storeMgr.getDatastoreAdapter();
    }

    protected MetaDataManager getMetaDataManager() {
        return this.pmf.getNucleusContext().getMetaDataManager();
    }

    protected void checkValid(Class pc, String fieldName) throws IllegalArgumentException, NullPointerException {
        if (pc == null || fieldName == null) {
            throw new NullPointerException("pc = " + pc + " / fieldName = " + fieldName);
        }
        if (!this.isGeometryColumnBackedField(pc, fieldName)) {
            throw new IllegalArgumentException("'" + pc.getName() + "#" + fieldName + "' is not a geometry column backed field.");
        }
    }

    protected Object readFirstValueForField(final Class pc, final String fieldName, final PersistenceManager pm) {
        return new QueryExecutor(pm.currentTransaction()){

            @Override
            Query getQuery() {
                Query q = pm.newQuery(pc);
                q.setResult(fieldName);
                q.setUnique(true);
                q.setRange(0L, 1L);
                return q;
            }
        }.execute();
    }

    protected abstract class QueryExecutor {
        private Transaction tx;

        QueryExecutor(Transaction tx) {
            this.tx = tx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object execute() {
            Object result = null;
            boolean isActive = this.tx.isActive();
            try {
                if (!isActive) {
                    this.tx.begin();
                }
                result = this.getQuery().execute();
            }
            finally {
                if (!isActive) {
                    this.tx.rollback();
                }
            }
            return result;
        }

        abstract Query getQuery();
    }
}

