/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class RectangleStringConverter
implements TypeConverter<Rectangle, String> {
    public Rectangle toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Rectangle r = new Rectangle();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        int x = 0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Double.valueOf(token).intValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        int y = 0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Double.valueOf(token).intValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        int width = 0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                width = Double.valueOf(token).intValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        int height = 0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                height = Double.valueOf(token).intValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        r.setRect(x, y, width, height);
        return r;
    }

    public String toDatastoreType(Rectangle rect) {
        return rect != null ? "(" + rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight() + ")" : null;
    }
}

