/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.jts.GeometryMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.GeometryLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class GeometryExpression
extends SQLExpression {
    public GeometryExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, GeometryExpression.getMappingForUseWithExpression(mapping));
    }

    public GeometryExpression(Expression.MonadicOperator op, SQLExpression expr1) {
        super(op, expr1);
    }

    public GeometryExpression(SQLExpression expr1, Expression.DyadicOperator op, SQLExpression expr2) {
        super(expr1, op, expr2);
    }

    public GeometryExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List args, List types) {
        super(stmt, GeometryExpression.getMappingForUseWithExpression(mapping), functionName, args, types);
    }

    protected static JavaTypeMapping getMappingForUseWithExpression(JavaTypeMapping mapping) {
        if (mapping == null) {
            return null;
        }
        if (mapping instanceof GeometryMapping) {
            return ((GeometryMapping)mapping).getMappingWithoutUserData();
        }
        return mapping;
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq((SQLExpression)this);
        }
        if (expr instanceof GeometryLiteral) {
            return new BooleanExpression((SQLExpression)this, Expression.OP_EQ, expr);
        }
        if (expr instanceof GeometryExpression) {
            return new BooleanExpression((SQLExpression)this, Expression.OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.ne((SQLExpression)this);
        }
        if (expr instanceof GeometryLiteral) {
            return new BooleanExpression((SQLExpression)this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof GeometryExpression) {
            return new BooleanExpression((SQLExpression)this, Expression.OP_NOTEQ, expr);
        }
        return super.ne(expr);
    }

    public SQLExpression invoke(String methodName, List args) {
        if (this.mapping == null) {
            throw new NucleusException("Call to invoke on " + (Object)((Object)this) + " but the expression has a null mapping!");
        }
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, this.mapping.getType(), methodName, (SQLExpression)this, args);
    }
}

