/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.jts2postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.PostGISTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.postgis.PGgeometry;
import org.postgis.jts.JtsGeometry;

public class GeometryRDBMSMapping
extends AbstractDatastoreMapping {
    private static final SQLTypeInfo typeInfo = (SQLTypeInfo)PostGISTypeInfo.TYPEINFO_PROTOTYPE.clone();
    private static WKTReader wktReader;

    public GeometryRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return typeInfo;
    }

    public Object getObject(ResultSet rs, int exprIndex) {
        Geometry value;
        block6: {
            value = null;
            try {
                Object result = rs.getObject(exprIndex);
                if (rs.wasNull() || result == null) {
                    value = null;
                    break block6;
                }
                if (result instanceof JtsGeometry) {
                    value = ((JtsGeometry)result).getGeometry();
                    break block6;
                }
                if (!(result instanceof PGgeometry)) break block6;
                try {
                    value = this.convertGeometry((PGgeometry)result);
                }
                catch (ParseException e) {
                    throw new NucleusDataStoreException(this.failureMessage("getObject", result, (Exception)((Object)e)), (Throwable)e);
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, e), (Throwable)e);
            }
        }
        return value;
    }

    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ps.setNull(exprIndex, this.getTypeInfo().getDataType(), this.getTypeInfo().getTypeName());
            } else {
                JtsGeometry obj = new JtsGeometry((Geometry)value);
                ps.setObject(exprIndex, obj);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
    }

    private Geometry convertGeometry(PGgeometry pg) throws SQLException, ParseException {
        Geometry geom;
        String geometryString = pg.getGeometry().toString();
        if (wktReader == null) {
            wktReader = new WKTReader();
        }
        if (geometryString.indexOf(59) != -1) {
            String[] temp = PGgeometry.splitSRID((String)geometryString);
            int srid = Integer.parseInt(temp[0].substring(5));
            geom = wktReader.read(temp[1]);
            geom.setSRID(srid);
        } else {
            geom = wktReader.read(geometryString);
        }
        return geom;
    }

    static {
        typeInfo.setLocalTypeName("GEOMETRY");
    }
}

