/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.GeometryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.sql.method.SpatialMethodHelper;

public class SpatialBufferMethod2
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr == null && (args == null || args.size() != 2)) {
            throw new NucleusUserException("Cannot invoke Spatial.buffer without 2 arguments");
        }
        if (expr != null && args != null && args.size() != 1) {
            throw new NucleusUserException("Cannot invoke geom.buffer without 1 argument");
        }
        SQLExpression geomExpr = null;
        SQLExpression distExpr = null;
        if (expr == null) {
            geomExpr = (SQLExpression)args.get(0);
            distExpr = (SQLExpression)args.get(1);
        } else {
            geomExpr = expr;
            distExpr = (SQLExpression)args.get(0);
        }
        ArrayList<SQLExpression> geomFuncArgs = new ArrayList<SQLExpression>();
        geomFuncArgs.add(geomExpr);
        GeometryExpression geomExpr2 = new GeometryExpression(this.stmt, null, "geometry.from_sdo_geom", geomFuncArgs, null);
        ArrayList<SQLExpression> geomBufferFuncArgs = new ArrayList<SQLExpression>();
        geomBufferFuncArgs.add(geomExpr2);
        geomBufferFuncArgs.add(distExpr);
        GeometryExpression geomBufferExpr = new GeometryExpression(this.stmt, null, "buffer", geomBufferFuncArgs, null);
        ArrayList<GeometryExpression> funcArgs = new ArrayList<GeometryExpression>();
        funcArgs.add(geomBufferExpr);
        JavaTypeMapping geomMapping = SpatialMethodHelper.getGeometryMapping(this.clr, geomExpr);
        return new GeometryExpression(this.stmt, geomMapping, "geometry.get_sdo_geom", funcArgs, null);
    }
}

