/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class CQLQueryResult
extends AbstractQueryResult {
    private static final long serialVersionUID = -3428653031644090769L;
    private ResultSet rs;
    private Iterator<Row> resultIter;
    private List<Row> resultObjs = new ArrayList<Row>();
    private int resultObjsIndex = 0;
    private boolean endOfResults = false;
    private int fetchSize = 1;

    public CQLQueryResult(Query query, ResultSet rs) {
        super(query);
        this.rs = rs;
    }

    public void initialise() {
        this.resultIter = this.rs.iterator();
        if (!this.resultIter.hasNext()) {
            this.endOfResults = true;
            this.closeResults();
            return;
        }
        this.fetchSize = this.query.getFetchPlan().getFetchSize();
        if (this.fetchSize == -1) {
            this.loadNumberOfResults(-1);
        } else if (this.fetchSize > 0) {
            this.loadNumberOfResults(this.fetchSize);
        }
    }

    private void loadNumberOfResults(int number) {
        if (this.endOfResults) {
            return;
        }
        if (number < 0) {
            this.resultObjs = this.rs.all();
            this.endOfResults = true;
        } else {
            int idx = 0;
            while (this.resultIter.hasNext()) {
                Row row = this.resultIter.next();
                this.resultObjs.add(row);
                if (++idx != number) continue;
                if (this.resultIter.hasNext()) break;
                this.endOfResults = true;
                break;
            }
        }
    }

    protected void closingConnection() {
    }

    public void disconnect() {
        if (this.query == null) {
            return;
        }
        this.resultIter = null;
        this.rs = null;
        this.resultObjs = null;
    }

    public synchronized void close() {
        super.close();
        this.resultIter = null;
        this.rs = null;
        this.resultObjs = null;
    }

    protected void closeResults() {
    }

    public boolean equals(Object o) {
        if (null == o || !(o instanceof CQLQueryResult)) {
            return false;
        }
        CQLQueryResult other = (CQLQueryResult)((Object)o);
        if (this.rs != null) {
            return other.rs == this.rs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)((Object)other)).equals(StringUtils.toJVMIDString((Object)((Object)this)));
    }

    public int hashCode() {
        if (this.rs != null) {
            return this.rs.hashCode();
        }
        if (this.query != null) {
            return this.query.hashCode();
        }
        return StringUtils.toJVMIDString((Object)((Object)this)).hashCode();
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Iterator iterator() {
        return new CQLResultIterator();
    }

    public ListIterator listIterator() {
        return new CQLResultIterator();
    }

    private class CQLResultIterator
    extends AbstractQueryResultIterator {
        private CQLResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            CQLQueryResult cQLQueryResult = CQLQueryResult.this;
            synchronized (cQLQueryResult) {
                if (!CQLQueryResult.this.isOpen()) {
                    return false;
                }
                if (CQLQueryResult.this.resultObjsIndex < CQLQueryResult.this.resultObjs.size()) {
                    return true;
                }
                if (!CQLQueryResult.this.endOfResults) {
                    return CQLQueryResult.this.resultIter.hasNext();
                }
                return false;
            }
        }

        public Object next() {
            CQLQueryResult cQLQueryResult = CQLQueryResult.this;
            synchronized (cQLQueryResult) {
                if (!CQLQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(Localiser.msg((String)"052600"));
                }
                int resultObjsSize = CQLQueryResult.this.resultObjs.size();
                if (CQLQueryResult.this.resultObjsIndex < resultObjsSize) {
                    Row currentElement = CQLQueryResult.this.resultObjs.get(CQLQueryResult.this.resultObjsIndex++);
                    if (CQLQueryResult.this.resultObjsIndex == resultObjsSize) {
                        CQLQueryResult.this.loadNumberOfResults(CQLQueryResult.this.fetchSize);
                    }
                    return currentElement;
                }
                throw new NoSuchElementException(Localiser.msg((String)"052602"));
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

