/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.transaction.xa.XAResource;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractEmulatedXAResource;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    public static final String CASSANDRA_CONNECTION_PER_MANAGER = "datanucleus.cassandra.sessionPerManager";
    public static final String CASSANDRA_COMPRESSION = "datanucleus.cassandra.compression";
    public static final String CASSANDRA_METRICS = "datanucleus.cassandra.metrics";
    public static final String CASSANDRA_SSL = "datanucleus.cassandra.ssl";
    public static final String CASSANDRA_SOCKET_READ_TIMEOUT_MILLIS = "datanucleus.cassandra.socket.readTimeoutMillis";
    public static final String CASSANDRA_SOCKET_CONNECT_TIMEOUT_MILLIS = "datanucleus.cassandra.socket.connectTimeoutMillis";
    public static final String CASSANDRA_LOAD_BALANCING_POLICY = "datanucleus.cassandra.loadBalancingPolicy";
    public static final String CASSANDRA_LOAD_BALANCING_POLICY_TOKEN_AWARE_LOCAL_DC = "datanucleus.cassandra.loadBalancingPolicy.tokenAwareLocalDC";
    boolean sessionPerManager = false;
    CqlSessionBuilder sessionBuilder = null;
    CqlSession session = null;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        Boolean sessionPerManagerProperty;
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.trim().substring(9).trim();
        if (remains.length() > 0) {
            remains = remains.substring(1);
        }
        StringTokenizer tokeniser = new StringTokenizer(remains, ",");
        ArrayList<String> hosts = new ArrayList<String>();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            if (token.indexOf(58) == 0) {
                token = token.substring(1).trim();
            }
            String hostStr = null;
            String portStr = null;
            int portNumber = 9042;
            if (!StringUtils.isWhitespace((String)token)) {
                int nextSemiColon = token.indexOf(58);
                if (nextSemiColon > 0) {
                    hostStr = token.substring(0, nextSemiColon);
                    portStr = token.substring(nextSemiColon + 1);
                    if (portStr != null) {
                        try {
                            portNumber = Integer.valueOf(portStr);
                        }
                        catch (NumberFormatException nfe) {
                            NucleusLogger.CONNECTION.warn((Object)("Unable to convert '" + portStr + "' to port number for Cassandra, so ignoring"));
                        }
                    }
                } else {
                    hostStr = token.trim();
                }
            }
            hosts.add(hostStr);
            ports.add(portNumber);
        }
        this.sessionBuilder = CqlSession.builder();
        if (!hosts.isEmpty()) {
            NucleusLogger.CONNECTION.debug((Object)("Starting Cassandra CqlSessionBuilder for hosts " + StringUtils.collectionToString(hosts)));
            Iterator hostIter = hosts.iterator();
            Iterator portIter = ports.iterator();
            while (hostIter.hasNext()) {
                String host = (String)hostIter.next();
                Integer port = (Integer)portIter.next();
                InetSocketAddress addr = new InetSocketAddress(host, (int)port);
                this.sessionBuilder.addContactPoint(addr);
            }
        } else {
            NucleusLogger.CONNECTION.debug((Object)"Starting Cassandra CqlSessionBuilder with default contact point(s)");
        }
        String user = storeMgr.getConnectionUserName();
        String passwd = storeMgr.getConnectionPassword();
        if (!StringUtils.isWhitespace((String)user)) {
            this.sessionBuilder.withAuthCredentials(user, passwd);
        }
        if ((sessionPerManagerProperty = storeMgr.getBooleanObjectProperty(CASSANDRA_CONNECTION_PER_MANAGER)) != null && sessionPerManagerProperty.booleanValue()) {
            this.sessionPerManager = true;
        }
    }

    public void close() {
        if (this.session != null) {
            NucleusLogger.CONNECTION.debug((Object)"Closed Cassandra CqlSession");
            this.session.close();
        }
        super.close();
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map options) {
        return new ManagedConnectionImpl();
    }

    static class EmulatedXAResource
    extends AbstractEmulatedXAResource {
        EmulatedXAResource(ManagedConnectionImpl mconn, CqlSession session) {
            super((ManagedConnection)mconn);
        }
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        XAResource xaRes = null;

        public Object getConnection() {
            if (this.conn == null) {
                this.obtainNewConnection();
            }
            return this.conn;
        }

        protected void obtainNewConnection() {
            if (this.conn == null) {
                if (ConnectionFactoryImpl.this.sessionPerManager) {
                    this.conn = ConnectionFactoryImpl.this.sessionBuilder.build();
                    NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - obtained CqlSession"));
                } else {
                    if (ConnectionFactoryImpl.this.session == null) {
                        ConnectionFactoryImpl.this.session = (CqlSession)ConnectionFactoryImpl.this.sessionBuilder.build();
                    }
                    NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - using connection"));
                    this.conn = ConnectionFactoryImpl.this.session;
                }
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - released connection"));
            }
        }

        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - closed connection"));
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
            if (ConnectionFactoryImpl.this.sessionPerManager) {
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - close CqlSession"));
                ((CqlSession)this.conn).close();
            }
            this.xaRes = null;
            super.close();
        }

        public XAResource getXAResource() {
            if (this.xaRes == null) {
                if (this.conn == null) {
                    this.obtainNewConnection();
                }
                this.xaRes = new EmulatedXAResource(this, (CqlSession)this.conn);
            }
            return this.xaRes;
        }

        public boolean closeAfterTransactionEnd() {
            if (ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.connection.singleConnectionPerExecutionContext")) {
                return false;
            }
            return super.closeAfterTransactionEnd();
        }
    }
}

