/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import java.util.Map;
import org.datanucleus.util.ConcurrentReferenceHashMap;

public class SessionStatementProvider {
    Map<String, PreparedStatement> preparedStatementCache = new ConcurrentReferenceHashMap(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public void close() {
        this.preparedStatementCache.clear();
    }

    public PreparedStatement prepare(String stmt, Session session) {
        PreparedStatement ps = this.preparedStatementCache.get(stmt);
        if (ps == null) {
            ps = session.prepare(stmt);
            this.preparedStatementCache.put(stmt, ps);
        }
        return ps;
    }
}

