/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query.expression;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.cassandra.query.expression.CassandraExpression;
import org.datanucleus.store.cassandra.query.expression.CassandraFieldExpression;
import org.datanucleus.store.cassandra.query.expression.CassandraLiteral;
import org.datanucleus.util.NucleusLogger;

public class CassandraBooleanExpression
extends CassandraExpression {
    String cql = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CassandraBooleanExpression(CassandraExpression leftExpr, CassandraExpression rightExpr, Expression.Operator op) {
        if (op == Expression.OP_EQ || op == Expression.OP_NOTEQ || op == Expression.OP_LT || op == Expression.OP_LTEQ || op == Expression.OP_GT || op == Expression.OP_GTEQ) {
            String leftCql = null;
            if (leftExpr instanceof CassandraFieldExpression) {
                leftCql = ((CassandraFieldExpression)leftExpr).getColumnName();
            } else {
                if (!(leftExpr instanceof CassandraLiteral)) throw new NucleusException("Cannot create CassandraBooleanExpression with left argument of type " + leftExpr.getClass().getName());
                Object value = ((CassandraLiteral)leftExpr).getValue();
                leftCql = value instanceof String || value instanceof Character ? "'" + value + "'" : "" + value;
            }
            String rightCql = null;
            if (rightExpr instanceof CassandraFieldExpression) {
                rightCql = ((CassandraFieldExpression)rightExpr).getColumnName();
            } else {
                if (!(rightExpr instanceof CassandraLiteral)) throw new NucleusException("Cannot create CassandraBooleanExpression with right argument of type " + rightExpr.getClass().getName());
                Object value = ((CassandraLiteral)rightExpr).getValue();
                rightCql = value instanceof String || value instanceof Character ? "'" + value + "'" : "" + value;
            }
            if (op == Expression.OP_NOTEQ) {
                NucleusLogger.QUERY.warn((Object)"CQL has no NOT operator! so you need to change your query");
            }
            this.cql = leftCql + op.toString() + rightCql;
            return;
        } else {
            if (op != Expression.OP_AND && op != Expression.OP_OR) throw new NucleusException("Cannot create CassandraBooleanExpression with operator of " + op + " with this constructor");
            if (!(leftExpr instanceof CassandraBooleanExpression) || !(rightExpr instanceof CassandraBooleanExpression)) throw new NucleusException("Cannot create CassandraBooleanExpression with left=" + leftExpr.getClass().getName() + " right=" + rightExpr.getClass().getName());
            this.cql = "(" + ((CassandraBooleanExpression)leftExpr).getCQL() + ")" + op.toString() + "(" + ((CassandraBooleanExpression)rightExpr).getCQL() + ")";
        }
    }

    public String getCQL() {
        return this.cql;
    }

    public String toString() {
        return this.cql.toString();
    }
}

