/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CQLQuery
extends AbstractJavaQuery {
    private static final long serialVersionUID = 2808968696540162104L;
    String cql;

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (CQLQuery)null);
    }

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec, CQLQuery q) {
        super(storeMgr, ec);
        this.cql = q.cql;
    }

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec);
        this.cql = query;
    }

    public String getSingleStringQuery() {
        return this.cql;
    }

    public void compileGeneric(Map parameterValues) {
    }

    protected void compileInternal(Map parameterValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        try {
            Session session = (Session)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"JDOQL", this.getSingleStringQuery(), null}));
            }
            ResultSet rs = session.execute(this.cql);
            List defs = rs.getColumnDefinitions().asList();
            for (Row row : rs) {
                Object[] resultRow = new Object[defs.size()];
                int i = 0;
                for (ColumnDefinitions.Definition def : defs) {
                    DataType colType = def.getType();
                    if (colType == DataType.varchar()) {
                        resultRow[i] = row.getString(i);
                    } else if (colType == DataType.bigint()) {
                        resultRow[i] = row.getLong(i);
                    } else if (colType == DataType.decimal()) {
                        resultRow[i] = row.getDecimal(i);
                    } else if (colType == DataType.cfloat()) {
                        resultRow[i] = Float.valueOf(row.getFloat(i));
                    } else if (colType == DataType.cdouble()) {
                        resultRow[i] = row.getDouble(i);
                    } else if (colType == DataType.cboolean()) {
                        resultRow[i] = row.getBool(i);
                    } else if (colType == DataType.timestamp()) {
                        resultRow[i] = row.getDate(i);
                    } else if (colType == DataType.varint()) {
                        resultRow[i] = row.getInt(i);
                    } else {
                        NucleusLogger.QUERY.warn((Object)("Column " + i + " of results is of unsupported type (" + colType + ") : returning null"));
                        resultRow[i] = null;
                    }
                    ++i;
                }
                results.add(resultRow);
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"JDOQL", "" + (System.currentTimeMillis() - startTime)}));
            }
            ArrayList<Object[]> arrayList = results;
            return arrayList;
        }
        finally {
            mconn.release();
        }
    }
}

