/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.driver.core.Session;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.util.NucleusLogger;

public class CQLQuery
extends AbstractJavaQuery {
    String cql;

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (CQLQuery)null);
    }

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec, CQLQuery q) {
        super(storeMgr, ec);
        this.cql = q.cql;
    }

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec);
        this.cql = query;
    }

    public String getSingleStringQuery() {
        return this.cql;
    }

    protected void compileInternal(Map parameterValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            Session session = (Session)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
            }
            session.execute(this.cql);
            Object results = null;
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Object var7_6 = results;
            return var7_6;
        }
        finally {
            mconn.release();
        }
    }
}

