/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.fieldmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.cassandra.fieldmanager.StoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public StoreEmbeddedFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, boolean insert, List<AbstractMemberMetaData> mmds) {
        super(ec, cmd, insert);
        this.mmds = mmds;
    }

    public StoreEmbeddedFieldManager(ObjectProvider op, boolean insert, List<AbstractMemberMetaData> mmds) {
        super(op, insert);
        this.mmds = mmds;
    }

    @Override
    protected Column getColumn(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getColumnForEmbeddedMember(embMmds);
    }

    @Override
    protected String getColumnName(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.ec.getStoreManager().getNamingFactory().getColumnName(embMmds, 0);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMemberMetaData lastMmd = this.mmds.get(this.mmds.size() - 1);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            ObjectProvider[] ownerOPs;
            if (this.op != null && (ownerOPs = this.op.getEmbeddedOwners()) != null && ownerOPs.length == 1 && value != ownerOPs[0].getObject()) {
                this.op.replaceField(fieldNumber, ownerOPs[0].getObject());
            }
            return;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, lastMmd)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
                embMmds.add(mmd);
                if (value == null) {
                    StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.insert, embMmds);
                    for (int i = 0; i < embMmdPosns.length; ++i) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                        if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                            ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                            colEmbMmds.add(embMmd);
                            String colName = this.ec.getStoreManager().getNamingFactory().getColumnName(colEmbMmds, 0);
                            this.columnValueByName.put(colName, null);
                            continue;
                        }
                        if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                        storeEmbFM.storeObjectField(embMmdPosns[i], null);
                    }
                    Map<String, Object> embColValuesByName = storeEmbFM.getColumnValueByName();
                    this.columnValueByName.putAll(embColValuesByName);
                    return;
                }
                ObjectProvider embOP = this.ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embOP, this.insert, embMmds);
                embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)storeEmbFM);
                Map<String, Object> embColValuesByName = storeEmbFM.getColumnValueByName();
                this.columnValueByName.putAll(embColValuesByName);
                return;
            }
            NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded), storing as null"));
            this.columnValueByName.put(this.getColumnName(fieldNumber), null);
            return;
        }
        if (this.op == null) {
            this.columnValueByName.put(this.getColumnName(fieldNumber), null);
            return;
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }
}

