/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.fieldmanager;

import com.datastax.driver.core.Row;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected Row row;

    public FetchFieldManager(ObjectProvider op, Row row) {
        super(op);
        this.row = row;
    }

    public FetchFieldManager(ExecutionContext ec, Row row, AbstractClassMetaData cmd) {
        super(ec, cmd);
        this.row = row;
    }

    protected String getColumnName(int fieldNumber) {
        return this.ec.getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return this.row.getBool(this.getColumnName(fieldNumber));
    }

    public char fetchCharField(int fieldNumber) {
        return this.row.getString(this.getColumnName(fieldNumber)).charAt(0);
    }

    public byte fetchByteField(int fieldNumber) {
        return (byte)this.row.getInt(this.getColumnName(fieldNumber));
    }

    public short fetchShortField(int fieldNumber) {
        return (short)this.row.getInt(this.getColumnName(fieldNumber));
    }

    public int fetchIntField(int fieldNumber) {
        return this.row.getInt(this.getColumnName(fieldNumber));
    }

    public long fetchLongField(int fieldNumber) {
        return this.row.getLong(this.getColumnName(fieldNumber));
    }

    public float fetchFloatField(int fieldNumber) {
        return this.row.getFloat(this.getColumnName(fieldNumber));
    }

    public double fetchDoubleField(int fieldNumber) {
        return this.row.getDouble(this.getColumnName(fieldNumber));
    }

    public String fetchStringField(int fieldNumber) {
        return this.row.getString(this.getColumnName(fieldNumber));
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, this.row, embMmds);
                embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embOP.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded)"));
                return null;
            }
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }

    protected Object fetchNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        String colName = this.getColumnName(fieldNumber);
        if (this.row.isNull(colName)) {
            return null;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            String value = this.row.getString(colName);
            return this.getValueForSingleRelationField(mmd, value, clr);
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            Collection value = null;
            if (mmd.hasCollection()) {
                value = List.class.isAssignableFrom(mmd.getType()) || mmd.getOrderMetaData() != null ? this.row.getList(colName, String.class) : this.row.getSet(colName, String.class);
            } else if (mmd.hasMap()) {
                Class<String> keyCls = clr.classForName(mmd.getMap().getKeyType());
                if (mmd.getMap().keyIsPersistent()) {
                    keyCls = String.class;
                }
                Class<String> valCls = clr.classForName(mmd.getMap().getValueType());
                if (mmd.getMap().valueIsPersistent()) {
                    valCls = String.class;
                }
                value = this.row.getMap(colName, keyCls, valCls);
            } else if (mmd.hasArray()) {
                value = this.row.getList(colName, String.class);
            }
            return this.getValueForContainerRelationField(mmd, value, clr);
        }
        String cassandraType = CassandraUtils.getCassandraColumnTypeForMember(mmd, this.ec.getTypeManager(), clr);
        if (mmd.hasCollection()) {
            Collection cassColl = null;
            Class elementCls = clr.classForName(mmd.getCollection().getElementType());
            cassColl = List.class.isAssignableFrom(mmd.getType()) || mmd.getOrderMetaData() != null ? this.row.getList(colName, elementCls) : this.row.getSet(colName, elementCls);
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Field=" + mmd.getFullFieldName() + " has datastore collection=" + StringUtils.collectionToString((Collection)cassColl) + " not supported yet"));
        } else if (mmd.hasMap()) {
            Class keyCls = clr.classForName(mmd.getMap().getKeyType());
            Class valCls = clr.classForName(mmd.getMap().getValueType());
            Map cassMap = this.row.getMap(colName, keyCls, valCls);
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Field=" + mmd.getFullFieldName() + " has datastore map=" + StringUtils.mapToString((Map)cassMap) + " not supported yet"));
        } else if (!mmd.hasArray()) {
            if (mmd.isSerialized()) {
                ByteBuffer byteBuffer = this.row.getBytes(colName);
                byte[] bytes = byteBuffer.array();
                TypeConverter serialConv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, byte[].class);
                return serialConv.toMemberType((Object)bytes);
            }
            if (BigInteger.class.isAssignableFrom(mmd.getType())) {
                return BigInteger.valueOf(this.row.getLong(colName));
            }
            if (BigDecimal.class.isAssignableFrom(mmd.getType())) {
                return BigDecimal.valueOf(this.row.getDouble(colName));
            }
            if (Byte.class.isAssignableFrom(mmd.getType())) {
                return (byte)this.row.getInt(colName);
            }
            if (Character.class.isAssignableFrom(mmd.getType())) {
                return Character.valueOf(this.row.getString(colName).charAt(0));
            }
            if (Double.class.isAssignableFrom(mmd.getType())) {
                return this.row.getDouble(colName);
            }
            if (Float.class.isAssignableFrom(mmd.getType())) {
                return Float.valueOf(this.row.getFloat(colName));
            }
            if (Long.class.isAssignableFrom(mmd.getType())) {
                return this.row.getLong(colName);
            }
            if (Integer.class.isAssignableFrom(mmd.getType())) {
                return this.row.getInt(colName);
            }
            if (Short.class.isAssignableFrom(mmd.getType())) {
                return (short)this.row.getInt(colName);
            }
            if (Boolean.class.isAssignableFrom(mmd.getType())) {
                return this.row.getBool(colName);
            }
            if (Enum.class.isAssignableFrom(mmd.getType())) {
                if (cassandraType.equals("varchar")) {
                    return Enum.valueOf(mmd.getType(), this.row.getString(colName));
                }
                return mmd.getType().getEnumConstants()[this.row.getInt(colName)];
            }
            if (Date.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (cassandraType.equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(colName));
                }
                return new Date(this.row.getDate(colName).getTime());
            }
            if (Time.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (cassandraType.equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(colName));
                }
                return new Time(this.row.getDate(colName).getTime());
            }
            if (Timestamp.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (cassandraType.equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(colName));
                }
                return new Timestamp(this.row.getDate(colName).getTime());
            }
            if (Calendar.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (cassandraType.equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(colName));
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.row.getDate(colName));
                return cal;
            }
            if (java.util.Date.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (cassandraType.equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(colName));
                }
                return this.row.getDate(colName);
            }
            TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
            if (stringConverter != null) {
                return stringConverter.toMemberType((Object)this.row.getString(colName));
            }
            TypeConverter longConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
            if (longConverter != null) {
                return longConverter.toMemberType((Object)this.row.getLong(colName));
            }
        }
        NucleusLogger.PERSISTENCE.info((Object)("TODO FetchFM field=" + mmd.getFullFieldName() + " not supported currently. Type=" + mmd.getTypeName()));
        return null;
    }

    protected Object getValueForSingleRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (value == null) {
            return null;
        }
        String persistableId = (String)value;
        try {
            return IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)this.cmd, (ExecutionContext)this.ec);
        }
        catch (NucleusObjectNotFoundException onfe) {
            NucleusLogger.GENERAL.warn((Object)("Object=" + this.op + " field=" + mmd.getFullFieldName() + " has id=" + persistableId + " but could not instantiate object with that identity"));
            return null;
        }
    }

    protected Object getValueForContainerRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (mmd.hasCollection()) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 3, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            while (idIter.hasNext()) {
                String persistableId = (String)idIter.next();
                if (persistableId == null) {
                    coll.add(null);
                    continue;
                }
                try {
                    coll.add(IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (this.op != null) {
                coll = (Collection)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            Map mapIds = (Map)value;
            AbstractClassMetaData keyCmd = null;
            if (mmd.getMap().keyIsPersistent() && (keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager())) == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 5, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    keyCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (keyCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate key type (e.g interface or Object element types)");
                }
            }
            AbstractClassMetaData valCmd = null;
            if (mmd.getMap().valueIsPersistent() && (valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager())) == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 6, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    valCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (valCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate value type (e.g interface or Object element types)");
                }
            }
            Iterator entryIter = mapIds.entrySet().iterator();
            boolean changeDetected = false;
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                Object key = null;
                Object val = null;
                if (mmd.getMap().keyIsPersistent()) {
                    String keyPersistableId = (String)entry.getKey();
                    if (keyPersistableId == null) {
                        key = null;
                    } else {
                        try {
                            key = IdentityUtils.getObjectFromPersistableIdentity((String)keyPersistableId, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec);
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            changeDetected = true;
                        }
                    }
                } else {
                    key = entry.getKey();
                }
                if (mmd.getMap().valueIsPersistent()) {
                    String valPersistableId = (String)entry.getValue();
                    if (valPersistableId == null) {
                        val = null;
                    } else {
                        try {
                            val = IdentityUtils.getObjectFromPersistableIdentity((String)valPersistableId, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec);
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            changeDetected = true;
                        }
                    }
                } else {
                    val = entry.getValue();
                }
                map.put(key, val);
            }
            if (this.op != null) {
                map = (Map)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return map;
        }
        if (mmd.hasArray()) {
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 4, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Object array = Array.newInstance(mmd.getType().getComponentType(), collIds.size());
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            int pos = 0;
            while (idIter.hasNext()) {
                String persistableId = (String)idIter.next();
                if (persistableId == null) {
                    Array.set(array, pos++, null);
                    continue;
                }
                try {
                    Array.set(array, pos++, IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (changeDetected) {
                if (pos < collIds.size()) {
                    Object arrayOld = array;
                    array = Array.newInstance(mmd.getType().getComponentType(), pos);
                    for (int j = 0; j < pos; ++j) {
                        Array.set(array, j, Array.get(arrayOld, j));
                    }
                }
                if (this.op != null) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return array;
        }
        return value;
    }
}

