/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.ColumnAttributer;
import org.datanucleus.util.NucleusLogger;

public class ColumnAttributerImpl
implements ColumnAttributer {
    StoreManager storeMgr;
    AbstractClassMetaData cmd;
    ClassLoaderResolver clr;

    public ColumnAttributerImpl(StoreManager storeMgr, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.clr = clr;
    }

    public void attributeColumn(Column col, AbstractMemberMetaData mmd) {
        if (mmd != null) {
            String cassandraType = CassandraUtils.getCassandraColumnTypeForMember(mmd, this.storeMgr.getNucleusContext().getTypeManager(), this.clr);
            if (cassandraType == null) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Member " + mmd.getFullFieldName() + " of type " + mmd.getTypeName() + " has no supported cassandra type! Ignoring"));
            } else {
                col.setTypeName(cassandraType);
            }
        } else if (col.getColumnType() == ColumnType.DATASTOREID_COLUMN) {
            col.setTypeName("bigint");
        } else if (col.getColumnType() == ColumnType.VERSION_COLUMN) {
            String cassandraType = this.cmd.getVersionMetaDataForClass().getVersionStrategy() == VersionStrategy.DATE_TIME ? "timestamp" : "int";
            col.setTypeName(cassandraType);
        } else if (col.getColumnType() == ColumnType.DISCRIMINATOR_COLUMN) {
            col.setTypeName("varchar");
        } else if (col.getColumnType() == ColumnType.MULTITENANCY_COLUMN) {
            col.setTypeName("varchar");
        }
    }

    public void attributeEmbeddedColumn(Column col, List<AbstractMemberMetaData> mmds) {
        AbstractMemberMetaData mmd = mmds.get(mmds.size() - 1);
        String cassandraType = CassandraUtils.getCassandraColumnTypeForMember(mmd, this.storeMgr.getNucleusContext().getTypeManager(), this.clr);
        if (cassandraType == null) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Embedded member " + mmd.getFullFieldName() + " of type " + mmd.getTypeName() + " has no supported cassandra type! Ignoring"));
        } else {
            col.setTypeName(cassandraType);
        }
    }
}

