/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.Session;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraPersistenceHandler;
import org.datanucleus.store.cassandra.CassandraSchemaHandler;
import org.datanucleus.store.cassandra.ColumnAttributerImpl;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.naming.NamingCase;
import org.datanucleus.store.schema.table.ColumnAttributer;
import org.datanucleus.store.schema.table.CompleteClassTable;

public class CassandraStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    String schemaName = null;
    Map<Session, SessionStatementProvider> stmtProviderCache = new HashMap<Session, SessionStatementProvider>();

    public CassandraStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext nucleusCtx, Map<String, Object> props) {
        super("cassandra", clr, nucleusCtx, props);
        this.schemaHandler = new CassandraSchemaHandler(this);
        this.persistenceHandler = new CassandraPersistenceHandler((StoreManager)this);
        this.getNamingFactory().setNamingCase(NamingCase.LOWER_CASE);
        this.schemaName = this.getStringProperty("datanucleus.mapping.Schema");
        this.logConfiguration();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("DatastoreId");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        return set;
    }

    public void sessionClosing(Session session) {
        this.stmtProviderCache.remove(session);
    }

    public SessionStatementProvider getStatementProvider(Session session) {
        SessionStatementProvider provider = this.stmtProviderCache.get(session);
        if (provider == null) {
            provider = new SessionStatementProvider(session);
            this.stmtProviderCache.put(session, provider);
        }
        return provider;
    }

    public String getSchemaNameForClass(AbstractClassMetaData cmd) {
        if (cmd.getSchema() != null) {
            return cmd.getSchema();
        }
        if (this.schemaName != null) {
            return this.schemaName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        ManagedConnection mconn = this.getConnection(-1);
        try {
            Session session = (Session)mconn.getConnection();
            this.addClasses(classNames, clr, session);
        }
        finally {
            mconn.release();
        }
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr, Session session) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                CompleteClassTable table = new CompleteClassTable((StoreManager)this, (AbstractClassMetaData)cmd, (ColumnAttributer)new ColumnAttributerImpl((StoreManager)this, (AbstractClassMetaData)cmd, clr));
                sd = this.newStoreData(cmd, clr);
                sd.addProperty("tableObject", (Object)table);
                this.registerStoreData(sd);
            }
            HashSet<String> clsNameSet = new HashSet<String>();
            clsNameSet.add(cmd.getFullClassName());
            this.schemaHandler.createSchemaForClasses(clsNameSet, null, (Object)session);
        }
    }

    public void createSchema(String schemaName, Properties props) {
        this.schemaHandler.createSchema(schemaName, props, null);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.createSchemaForClasses(classNames, props, null);
    }

    public void deleteSchema(String schemaName, Properties props) {
        this.schemaHandler.deleteSchema(schemaName, props, null);
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.deleteSchemaForClasses(classNames, props, null);
    }

    public void validateSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.validateSchema(classNames, props, null);
    }
}

