/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.cassandra.fieldmanager.FetchFieldManager;
import org.datanucleus.store.cassandra.fieldmanager.StoreFieldManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CassandraPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER_CASSANDRA = Localiser.getInstance((String)"org.datanucleus.store.cassandra.Localisation", (ClassLoader)CassandraStoreManager.class.getClassLoader());
    protected Map<String, String> insertStatementByClassName;
    protected Map<String, String> deleteStatementByClassName;
    protected Map<String, String> locateStatementByClassName;

    public CassandraPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        AbstractClassMetaData cmd = op.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            Session session = (Session)mconn.getConnection();
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                ((CassandraStoreManager)this.storeMgr).addClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
            }
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                ((CassandraStoreManager)this.storeMgr).addClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Insert.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            String insertStmt = null;
            if (this.insertStatementByClassName != null) {
                insertStmt = this.insertStatementByClassName.get(cmd.getFullClassName());
            }
            StoreFieldManager storeFM = new StoreFieldManager(op, true);
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)storeFM);
            Map<String, Object> columnValuesByName = storeFM.getColumnValueByName();
            if (insertStmt == null) {
                insertStmt = this.getInsertStatementForClass(cmd, columnValuesByName);
                if (this.insertStatementByClassName == null) {
                    this.insertStatementByClassName = new HashMap<String, String>();
                }
                this.insertStatementByClassName.put(cmd.getFullClassName(), insertStmt);
            }
            Comparable<Integer> versionValue = null;
            if (cmd.isVersioned()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    int versionNumber = 1;
                    op.setTransactionalVersion((Object)versionNumber);
                    if (vermd.getFieldName() != null) {
                        AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                        Number verFieldValue = versionNumber;
                        if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                            verFieldValue = versionNumber;
                        }
                        op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                    }
                    versionValue = versionNumber;
                } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    Date date = new Date();
                    Timestamp ts = new Timestamp(date.getTime());
                    op.setTransactionalVersion((Object)ts);
                    if (vermd.getFieldName() != null) {
                        AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                        op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)ts);
                    }
                    versionValue = ts;
                }
            }
            String discrimValue = null;
            if (cmd.hasDiscriminatorStrategy()) {
                DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
                discrimValue = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            }
            String multitenancyValue = null;
            if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                multitenancyValue = this.storeMgr.getStringProperty("datanucleus.TenantID");
            }
            int numValues = columnValuesByName.size();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                ++numValues;
            }
            if (versionValue != null) {
                ++numValues;
            }
            if (discrimValue != null) {
                ++numValues;
            }
            if (multitenancyValue != null) {
                ++numValues;
            }
            Object[] stmtValues = new Object[numValues];
            int pos = 0;
            for (String colName : columnValuesByName.keySet()) {
                stmtValues[pos++] = columnValuesByName.get(colName);
            }
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                stmtValues[pos++] = ((OID)op.getInternalObjectId()).getKeyValue();
            }
            if (versionValue != null) {
                stmtValues[pos++] = versionValue;
            }
            if (discrimValue != null) {
                stmtValues[pos++] = discrimValue;
            }
            if (multitenancyValue != null) {
                stmtValues[pos++] = multitenancyValue;
            }
            CassandraUtils.logCqlStatement(insertStmt, stmtValues, NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
            PreparedStatement stmt = stmtProvider.prepare(insertStmt);
            BoundStatement boundStmt = stmt.bind(stmtValues);
            session.execute((Statement)boundStmt);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception inserting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    protected String getInsertStatementForClass(AbstractClassMetaData cmd, Map<String, Object> colValuesByName) {
        VersionMetaData vermd;
        NamingFactory namingFactory = this.storeMgr.getNamingFactory();
        StringBuilder insertStmtBuilder = new StringBuilder("INSERT INTO ");
        String schemaName = ((CassandraStoreManager)this.storeMgr).getSchemaNameForClass(cmd);
        if (schemaName != null) {
            insertStmtBuilder.append(schemaName).append('.');
        }
        insertStmtBuilder.append(namingFactory.getTableName(cmd)).append("(");
        int numParams = 0;
        if (colValuesByName != null && !colValuesByName.isEmpty()) {
            for (String colName : colValuesByName.keySet()) {
                if (numParams > 0) {
                    insertStmtBuilder.append(',');
                }
                insertStmtBuilder.append(colName);
                ++numParams;
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
            ++numParams;
        }
        if (cmd.isVersioned() && (vermd = cmd.getVersionMetaDataForClass()).getFieldName() == null) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.VERSION_COLUMN));
            ++numParams;
        }
        if (cmd.hasDiscriminatorStrategy()) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN));
            ++numParams;
        }
        if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN));
            ++numParams;
        }
        insertStmtBuilder.append(") ");
        insertStmtBuilder.append("VALUES (");
        for (int i = 0; i < numParams; ++i) {
            if (i > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append('?');
        }
        insertStmtBuilder.append(")");
        return insertStmtBuilder.toString();
    }

    public void insertObjects(ObjectProvider ... ops) {
        super.insertObjects(ops);
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        AbstractClassMetaData cmd = op.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            Session session = (Session)mconn.getConnection();
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                ((CassandraStoreManager)this.storeMgr).addClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
            }
            boolean fieldsToUpdate = false;
            for (int fieldNum : fieldNumbers) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNum);
                if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                fieldsToUpdate = true;
            }
            if (!fieldsToUpdate) {
                return;
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Update.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            if (cmd.isVersioned()) {
                Object currentVersion = op.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), (Object)currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                }
            }
            StoreFieldManager storeFM = new StoreFieldManager(op, false);
            op.provideFields(fieldNumbers, (FieldManager)storeFM);
            Map<String, Object> columnValuesByName = storeFM.getColumnValueByName();
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            StringBuilder stmtBuilder = new StringBuilder("UPDATE ");
            String schemaName = ((CassandraStoreManager)this.storeMgr).getSchemaNameForClass(cmd);
            if (schemaName != null) {
                stmtBuilder.append(schemaName).append('.');
            }
            stmtBuilder.append(namingFactory.getTableName(cmd));
            ArrayList<Object> setVals = new ArrayList<Object>();
            stmtBuilder.append(" SET ");
            if (columnValuesByName != null && !columnValuesByName.isEmpty()) {
                boolean first = true;
                for (Map.Entry<String, Object> entry : columnValuesByName.entrySet()) {
                    if (!first) {
                        stmtBuilder.append(',');
                    }
                    stmtBuilder.append(entry.getKey()).append("=?");
                    first = false;
                    setVals.add(entry.getValue());
                }
            }
            if (cmd.isVersioned()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (updatingVerField) {
                        stmtBuilder.append(',').append(namingFactory.getColumnName(verMmd, ColumnType.COLUMN)).append("=?");
                        setVals.add(op.getTransactionalVersion());
                    }
                } else {
                    stmtBuilder.append(",").append(namingFactory.getColumnName(cmd, ColumnType.VERSION_COLUMN)).append("=?");
                    Object verVal = op.getTransactionalVersion();
                    if (verVal instanceof Long) {
                        verVal = ((Long)op.getTransactionalVersion()).intValue();
                    }
                    setVals.add(verVal);
                }
            }
            stmtBuilder.append(" WHERE ");
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNums = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNums.length; ++i) {
                    if (i > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    stmtBuilder.append(namingFactory.getColumnName(cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]), ColumnType.COLUMN));
                    stmtBuilder.append("=?");
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                    String cassandraType = CassandraUtils.getCassandraColumnTypeForMember(pkMmd, ec.getTypeManager(), ec.getClassLoaderResolver());
                    setVals.add(CassandraUtils.getDatastoreValueForNonPersistableValue(op.provideField(pkFieldNums[i]), cassandraType, false, this.storeMgr.getNucleusContext().getTypeManager()));
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                stmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
                stmtBuilder.append("=?");
                Object oidVal = ((OID)op.getInternalObjectId()).getKeyValue();
                setVals.add(CassandraUtils.getDatastoreValueForNonPersistableValue(oidVal, "bigint", false, this.storeMgr.getNucleusContext().getTypeManager()));
            }
            CassandraUtils.logCqlStatement(stmtBuilder.toString(), setVals.toArray(), NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
            PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString());
            session.execute((Statement)stmt.bind(setVals.toArray()));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception updating object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Delete.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op, true));
            String deleteStmt = null;
            if (this.deleteStatementByClassName != null) {
                deleteStmt = this.deleteStatementByClassName.get(cmd.getFullClassName());
            }
            if (deleteStmt == null) {
                NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                StringBuilder stmtBuilder = new StringBuilder("DELETE FROM ");
                String schemaName = ((CassandraStoreManager)this.storeMgr).getSchemaNameForClass(cmd);
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                stmtBuilder.append(namingFactory.getTableName(cmd)).append(" WHERE ");
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNums = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNums.length; ++i) {
                        if (i > 0) {
                            stmtBuilder.append(" AND ");
                        }
                        stmtBuilder.append(namingFactory.getColumnName(cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]), ColumnType.COLUMN));
                        stmtBuilder.append("=?");
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    stmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
                    stmtBuilder.append("=?");
                }
                deleteStmt = stmtBuilder.toString();
                if (this.deleteStatementByClassName == null) {
                    this.deleteStatementByClassName = new HashMap<String, String>();
                }
                this.deleteStatementByClassName.put(cmd.getFullClassName(), deleteStmt);
            }
            Object[] pkVals = null;
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNums = cmd.getPKMemberPositions();
                pkVals = new Object[pkFieldNums.length];
                for (int i = 0; i < pkFieldNums.length; ++i) {
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                    String cassandraType = CassandraUtils.getCassandraColumnTypeForMember(pkMmd, ec.getTypeManager(), ec.getClassLoaderResolver());
                    pkVals[i] = CassandraUtils.getDatastoreValueForNonPersistableValue(op.provideField(pkFieldNums[i]), cassandraType, false, this.storeMgr.getNucleusContext().getTypeManager());
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                pkVals = new Object[]{((OID)op.getInternalObjectId()).getKeyValue()};
            }
            CassandraUtils.logCqlStatement(deleteStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
            Session session = (Session)mconn.getConnection();
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
            PreparedStatement stmt = stmtProvider.prepare(deleteStmt);
            session.execute((Statement)stmt.bind(pkVals));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception deleting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        super.deleteObjects(ops);
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(op.getObjectAsPrintable()).append("\" (id=");
                str.append(op.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Fetch.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            HashSet<Integer> nonpersistableFields = null;
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            boolean first = true;
            StringBuilder stmtBuilder = new StringBuilder("SELECT ");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                    RelationType relationType = mmd.getRelationType(clr);
                    if (RelationType.isRelationSingleValued((RelationType)relationType) && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, null)) {
                        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                        embMmds.add(mmd);
                        ArrayList<String> embColNames = new ArrayList<String>();
                        this.getColumnNamesForEmbeddedMember(embMmds, embColNames, ec);
                        for (String embColName : embColNames) {
                            if (!first) {
                                stmtBuilder.append(',');
                            }
                            stmtBuilder.append(embColName);
                            first = false;
                        }
                        continue;
                    }
                    String colName = namingFactory.getColumnName(mmd, ColumnType.COLUMN);
                    if (!first) {
                        stmtBuilder.append(',');
                    }
                    stmtBuilder.append(colName);
                    first = false;
                    continue;
                }
                if (nonpersistableFields == null) {
                    nonpersistableFields = new HashSet<Integer>();
                }
                nonpersistableFields.add(fieldNumbers[i]);
            }
            if (nonpersistableFields != null) {
                for (Integer fieldNum : nonpersistableFields) {
                    op.replaceField(fieldNum.intValue(), op.provideField(fieldNum.intValue()));
                }
            }
            if (nonpersistableFields == null || nonpersistableFields.size() != fieldNumbers.length) {
                stmtBuilder.append(" FROM ");
                String schemaName = ((CassandraStoreManager)this.storeMgr).getSchemaNameForClass(cmd);
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                stmtBuilder.append(namingFactory.getTableName(cmd)).append(" WHERE ");
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNums = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNums.length; ++i) {
                        if (i > 0) {
                            stmtBuilder.append(" AND ");
                        }
                        stmtBuilder.append(namingFactory.getColumnName(cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]), ColumnType.COLUMN));
                        stmtBuilder.append("=?");
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    stmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
                    stmtBuilder.append("=?");
                }
                Object[] pkVals = null;
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNums = cmd.getPKMemberPositions();
                    pkVals = new Object[pkFieldNums.length];
                    for (int i = 0; i < pkFieldNums.length; ++i) {
                        AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                        String cassandraType = CassandraUtils.getCassandraColumnTypeForMember(pkMmd, ec.getTypeManager(), ec.getClassLoaderResolver());
                        pkVals[i] = CassandraUtils.getDatastoreValueForNonPersistableValue(op.provideField(pkFieldNums[i]), cassandraType, false, this.storeMgr.getNucleusContext().getTypeManager());
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    pkVals = new Object[]{((OID)op.getInternalObjectId()).getKeyValue()};
                }
                CassandraUtils.logCqlStatement(stmtBuilder.toString(), pkVals, NucleusLogger.DATASTORE_NATIVE);
                Session session = (Session)mconn.getConnection();
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
                PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString());
                ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
                if (rs.isExhausted()) {
                    throw new NucleusObjectNotFoundException("Could not find object with id " + op.getInternalObjectId() + " op=" + op);
                }
                Row row = rs.one();
                FetchFieldManager fetchFM = new FetchFieldManager(op, row);
                if (nonpersistableFields != null) {
                    int[] persistableFieldNums = new int[fieldNumbers.length - nonpersistableFields.size()];
                    int pos = 0;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (nonpersistableFields.contains(fieldNumbers[i])) continue;
                        persistableFieldNums[pos++] = fieldNumbers[i];
                    }
                    fieldNumbers = persistableFieldNums;
                }
                op.replaceFields(fieldNumbers, (FieldManager)fetchFM);
                if (cmd.isVersioned() && op.getTransactionalVersion() == null) {
                    VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                    if (vermd.getFieldName() != null) {
                        Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                        op.setVersion(datastoreVersion);
                    } else {
                        String versColName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                        Integer datastoreVersion = row.getInt(versColName);
                        op.setVersion((Object)datastoreVersion);
                    }
                }
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementFetchCount();
                }
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception fetching object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception fetching object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    protected void getColumnNamesForEmbeddedMember(List<AbstractMemberMetaData> mmds, List<String> colNames, ExecutionContext ec) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(mmds.get(mmds.size() - 1).getType(), clr);
        int[] embFieldNums = embCmd.getAllMemberPositions();
        for (int i = 0; i < embFieldNums.length; ++i) {
            AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embFieldNums[i]);
            RelationType relationType = embMmd.getRelationType(clr);
            if (RelationType.isRelationSingleValued((RelationType)relationType) && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, embMmd, relationType, mmds.get(mmds.size() - 1))) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
                embMmds.add(embMmd);
                this.getColumnNamesForEmbeddedMember(embMmds, colNames, ec);
                continue;
            }
            ArrayList<AbstractMemberMetaData> colMmds = new ArrayList<AbstractMemberMetaData>(mmds);
            colMmds.add(embMmd);
            String colName = ec.getStoreManager().getNamingFactory().getColumnName(colMmds, 0);
            colNames.add(colName);
        }
    }

    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                String locateStmt = null;
                if (this.locateStatementByClassName != null) {
                    locateStmt = this.locateStatementByClassName.get(cmd.getFullClassName());
                }
                if (locateStmt == null) {
                    NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                    StringBuilder stmtBuilder = new StringBuilder("SELECT ");
                    if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                        int[] pkFieldNums = cmd.getPKMemberPositions();
                        for (int i = 0; i < pkFieldNums.length; ++i) {
                            if (i > 0) {
                                stmtBuilder.append(",");
                            }
                            stmtBuilder.append(namingFactory.getColumnName(cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]), ColumnType.COLUMN));
                        }
                    } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        stmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
                    }
                    stmtBuilder.append(" FROM ");
                    String schemaName = ((CassandraStoreManager)this.storeMgr).getSchemaNameForClass(cmd);
                    if (schemaName != null) {
                        stmtBuilder.append(schemaName).append('.');
                    }
                    stmtBuilder.append(namingFactory.getTableName(cmd)).append(" WHERE ");
                    if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                        int[] pkFieldNums = cmd.getPKMemberPositions();
                        for (int i = 0; i < pkFieldNums.length; ++i) {
                            if (i > 0) {
                                stmtBuilder.append(" AND ");
                            }
                            stmtBuilder.append(namingFactory.getColumnName(cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]), ColumnType.COLUMN));
                            stmtBuilder.append("=?");
                        }
                    } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        stmtBuilder.append(namingFactory.getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
                        stmtBuilder.append("=?");
                    }
                    locateStmt = stmtBuilder.toString();
                    if (this.locateStatementByClassName == null) {
                        this.locateStatementByClassName = new HashMap<String, String>();
                    }
                    this.locateStatementByClassName.put(cmd.getFullClassName(), locateStmt);
                }
                Object[] pkVals = null;
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNums = cmd.getPKMemberPositions();
                    pkVals = new Object[pkFieldNums.length];
                    for (int i = 0; i < pkFieldNums.length; ++i) {
                        AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                        String cassandraType = CassandraUtils.getCassandraColumnTypeForMember(pkMmd, ec.getTypeManager(), ec.getClassLoaderResolver());
                        pkVals[i] = CassandraUtils.getDatastoreValueForNonPersistableValue(op.provideField(pkFieldNums[i]), cassandraType, false, this.storeMgr.getNucleusContext().getTypeManager());
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    pkVals = new Object[]{((OID)op.getInternalObjectId()).getKeyValue()};
                }
                CassandraUtils.logCqlStatement(locateStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
                Session session = (Session)mconn.getConnection();
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
                PreparedStatement stmt = stmtProvider.prepare(locateStmt);
                ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
                if (rs.isExhausted()) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            catch (DriverException e) {
                NucleusLogger.PERSISTENCE.error((Object)("Exception locating object " + op), (Throwable)e);
                throw new NucleusDataStoreException("Exception locating object for " + op, (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    public void locateObjects(ObjectProvider[] ops) {
        super.locateObjects(ops);
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }
}

