/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.xmemcached;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.AbstractQueryResultsCache;
import org.datanucleus.util.NucleusLogger;

public class XmemcachedQueryResultCache
extends AbstractQueryResultsCache {
    private static final long serialVersionUID = 8865474095320516082L;
    public static final String PROPERTY_CACHE_QUERYRESULTS_MEMCACHED_SERVERS = "datanucleus.cache.queryResults.memcached.servers";
    public static final String PROPERTY_CACHE_QUERYRESULTS_MEMCACHED_KEYPREFIX = "datanucleus.cache.queryResults.memcached.keyprefix";
    private MemcachedClient client;
    private String keyPrefix = "datanucleus-query:";
    private int expirySeconds = 0;

    public XmemcachedQueryResultCache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String keyPrefix = conf.getStringProperty(PROPERTY_CACHE_QUERYRESULTS_MEMCACHED_KEYPREFIX);
        if (keyPrefix != null) {
            this.keyPrefix = keyPrefix;
        }
        this.expirySeconds = (int)this.expiryMillis / 1000;
        String servers = conf.getStringProperty(PROPERTY_CACHE_QUERYRESULTS_MEMCACHED_SERVERS);
        try {
            XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)servers));
            this.client = builder.build();
        }
        catch (IOException e) {
            NucleusLogger.CACHE.error((Object)"Exception caught creating cache", (Throwable)e);
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.client.flushAll();
            this.client.shutdown();
        }
        catch (Exception e) {
            NucleusLogger.CACHE.error((Object)"Exception caught shutting down cache", (Throwable)e);
        }
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public void evict(Class candidate) {
    }

    public void evict(Query query) {
        try {
            this.client.delete(this.keyPrefix + QueryUtils.getKeyForQueryResultsCache((Query)query, null));
        }
        catch (Exception e) {
            throw new NucleusException("Exception evicting entry from xmemcached", (Throwable)e);
        }
    }

    public void evict(Query query, Map params) {
        try {
            this.client.delete(this.keyPrefix + QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params));
        }
        catch (Exception e) {
            throw new NucleusException("Exception evicting entry from xmemcached", (Throwable)e);
        }
    }

    public void evictAll() {
        try {
            this.client.flushAll();
        }
        catch (Exception e) {
            throw new NucleusException("Exception evicting entries from xmemcached", (Throwable)e);
        }
    }

    public List<Object> get(String queryKey) {
        try {
            return (List)this.client.get(this.keyPrefix + queryKey);
        }
        catch (Exception e) {
            throw new NucleusException("Exception thrown in retrieval from xmemcached", (Throwable)e);
        }
    }

    public List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        try {
            this.client.set(this.keyPrefix + queryKey, this.expirySeconds, results);
        }
        catch (Exception e) {
            throw new NucleusException("Exception thrown in persistence to xmemcached", (Throwable)e);
        }
        return results;
    }
}

