/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.oscache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;

public class OSCacheLevel2Cache
extends AbstractLevel2Cache {
    private static final long serialVersionUID = -2975118169574839235L;
    private final GeneralCacheAdministrator cache = new GeneralCacheAdministrator();

    public OSCacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
        this.cache.destroy();
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        try {
            return (CachedPC)this.cache.getFromCache(this.toString(oid));
        }
        catch (NeedsRefreshException e) {
            this.cache.cancelUpdate(this.toString(oid));
            return null;
        }
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.containsOid(oid)) {
            this.evict(oid);
        }
        this.cache.putInCache(this.toString(oid), (Object)pc);
        return pc;
    }

    public void evict(Object oid) {
        this.cache.flushEntry(this.toString(oid));
    }

    public void evictAll() {
        this.cache.flushAll();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    private String toString(Object key) {
        if (this.cacheName != null) {
            return String.valueOf(key) + '.' + this.cacheName;
        }
        return String.valueOf(key);
    }
}

