/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.swarmcache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import net.sf.swarmcache.CacheFactory;
import net.sf.swarmcache.ObjectCache;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;

public class SwarmCacheLevel2Cache
extends AbstractLevel2Cache {
    private static final long serialVersionUID = -8430359936229487099L;
    private final ObjectCache cache;

    public SwarmCacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        CacheFactory factory = new CacheFactory(null);
        this.cache = factory.createCache(this.cacheName);
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        if (oid instanceof Serializable) {
            return (CachedPC)this.cache.get((Serializable)oid);
        }
        throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
    }

    public int getSize() {
        throw new UnsupportedOperationException("getSize() method not yet supported by SwarmCache plugin");
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (!(oid instanceof Serializable)) {
            throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
        }
        this.cache.put((Serializable)oid, (Object)pc);
        return pc;
    }

    public void evict(Object oid) {
        if (!(oid instanceof Serializable)) {
            throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
        }
        this.cache.clear((Serializable)oid);
    }

    public void evictAll() {
        this.cache.clearAll();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by SwarmCache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }
}

