/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.ehcache;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class EhcacheClassBasedLevel2Cache
extends AbstractLevel2Cache {
    private final CacheManager cacheManager;
    private final Cache defaultCache;
    private final Map<String, Cache> caches = new HashMap<String, Cache>();

    public EhcacheClassBasedLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.level2.configurationFile");
        try {
            this.cacheManager = configFile == null ? CacheManager.create() : CacheManager.create((URL)CacheManager.class.getResource(configFile));
        }
        catch (CacheException e) {
            throw new NucleusException(Localiser.msg((String)"Cache.EHCache.CacheManagerInitialiseFails", (Object[])new Object[]{e}));
        }
        if (!this.cacheManager.cacheExists(this.cacheName)) {
            try {
                this.cacheManager.addCache(this.cacheName);
            }
            catch (IllegalStateException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException(Localiser.msg((String)"Cache.EHCache.CreateDefaultFails", (Object[])new Object[]{e}));
            }
            catch (ObjectExistsException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException(Localiser.msg((String)"Cache.EHCache.CreateDefaultFails", (Object[])new Object[]{e}));
            }
            catch (CacheException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException(Localiser.msg((String)"Cache.EHCache.CreateDefaultFails", (Object[])new Object[]{e}));
            }
        }
        this.defaultCache = this.cacheManager.getCache(this.cacheName);
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
        this.cacheManager.shutdown();
    }

    public boolean containsOid(Object oid) {
        try {
            return this.get(oid) != null;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.containsOid : " + e.getMessage()));
            return false;
        }
    }

    public CachedPC get(Object oid) {
        try {
            Element element = this.getCacheForId(oid).get((Serializable)oid);
            if (element == null) {
                return null;
            }
            return this.toPC(element);
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        return null;
    }

    private CachedPC toPC(Element object) {
        return (CachedPC)object.getObjectValue();
    }

    private Element toElement(Object oid, CachedPC object) {
        return new Element((Serializable)oid, (Serializable)object);
    }

    public int getSize() {
        try {
            int size = this.defaultCache.getSize();
            Iterator<Cache> i = this.caches.values().iterator();
            while (i.hasNext()) {
                size += i.next().getSize();
            }
            return size;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSIze : " + e.getMessage()));
        }
        return 0;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        this.getCacheForId(oid).put(this.toElement(oid, pc));
        return pc;
    }

    public void evict(Object oid) {
        CachedPC pc = this.get(oid);
        if (pc != null) {
            this.getCacheForId(oid).remove((Serializable)oid);
        }
    }

    public void evictAll() {
        try {
            Iterator<Cache> i = this.caches.values().iterator();
            while (i.hasNext()) {
                i.next().removeAll();
            }
            this.defaultCache.removeAll();
        }
        catch (Exception e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.clear : " + e.getMessage()));
        }
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        String[] subclassNames;
        if (!this.nucleusCtx.getApiAdapter().isPersistable(pcClass)) {
            return;
        }
        this.evictAllOfClass(pcClass.getName());
        if (subclasses && (subclassNames = this.nucleusCtx.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                this.evictAllOfClass(subclassNames[i]);
            }
        }
    }

    void evictAllOfClass(String className) {
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(className, this.nucleusCtx.getClassLoaderResolver(null));
        Cache cache = null;
        if (cmd.usesSingleFieldIdentityClass() || cmd.getIdentityType() == IdentityType.DATASTORE) {
            cache = this.caches.get(cmd.getFullClassName());
            cache.removeAll();
        } else {
            cache = this.defaultCache;
            Iterator keyIter = cache.getKeys().iterator();
            while (keyIter.hasNext()) {
                String targetClassName;
                Object key = keyIter.next();
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    targetClassName = IdentityUtils.getTargetClassNameForIdentitySimple(key);
                    if (!className.equals(targetClassName)) continue;
                    keyIter.remove();
                    continue;
                }
                if (cmd.getIdentityType() != IdentityType.DATASTORE || !className.equals(targetClassName = IdentityUtils.getTargetClassNameForIdentitySimple(key))) continue;
                keyIter.remove();
            }
        }
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    private Cache getCacheForClass(String pcClassName) {
        Cache cache = this.caches.get(pcClassName);
        if (cache == null) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug((Object)Localiser.msg((String)"Cache.EHCache.Initialising", (Object[])new Object[]{pcClassName}));
            }
            if (this.cacheManager.cacheExists(pcClassName)) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug((Object)Localiser.msg((String)"Cache.EHCache.Exists", (Object[])new Object[]{pcClassName}));
                }
                cache = this.cacheManager.getCache(pcClassName);
            } else {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug((Object)Localiser.msg((String)"Cache.EHCache.CacheDoesntExist"));
                }
                if (this.defaultCache == null) {
                    NucleusLogger.CACHE.error((Object)Localiser.msg((String)"Cache.EHCache.CacheDoestExistNoDefault", (Object[])new Object[]{pcClassName}));
                }
                cache = this.defaultCache;
            }
            this.caches.put(pcClassName, cache);
        }
        return cache;
    }

    private Cache getCacheForId(Object id) {
        if (IdentityUtils.isSingleFieldIdentity((Object)id) || IdentityUtils.isDatastoreIdentity((Object)id)) {
            return this.getCacheForClass(IdentityUtils.getTargetClassNameForIdentitySimple((Object)id));
        }
        return this.defaultCache;
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.cache.ehcache.Localisation_ehcache", (ClassLoader)EhcacheClassBasedLevel2Cache.class.getClassLoader());
    }
}

