/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.xmemcached;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmemcachedQueryResultCache
implements QueryResultsCache {
    private MemcachedClient client;
    private String keyPrefix = "datanucleus-query:";
    private int expireSeconds = 0;

    public XmemcachedQueryResultCache(NucleusContext nucleusCtx) {
        PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
        String keyPrefix = conf.getStringProperty("datanucleus.cache.query.memcached.keyprefix");
        if (keyPrefix != null) {
            this.keyPrefix = keyPrefix;
        }
        String servers = conf.getStringProperty("datanucleus.cache.level2.memcached.servers");
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)servers));
        try {
            this.client = builder.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        String expireStr = conf.getStringProperty("datanucleus.cache.query.memcached.expireSeconds");
        if (!StringUtils.isWhitespace((String)expireStr)) {
            this.expireSeconds = Integer.parseInt(expireStr);
        }
    }

    public void close() {
        try {
            this.client.flushAll();
            this.client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public void evict(Class candidate) {
    }

    public synchronized void evict(Query query) {
        try {
            this.client.delete(this.keyPrefix + QueryUtils.getKeyForQueryResultsCache((Query)query, null));
        }
        catch (Exception e) {
            throw new NucleusException("Exception evicting entry from xmemcached", (Throwable)e);
        }
    }

    public synchronized void evict(Query query, Map params) {
        try {
            this.client.delete(this.keyPrefix + QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params));
        }
        catch (Exception e) {
            throw new NucleusException("Exception evicting entry from xmemcached", (Throwable)e);
        }
    }

    public synchronized void evictAll() {
        try {
            this.client.flushAll();
        }
        catch (Exception e) {
            throw new NucleusException("Exception evicting entries from xmemcached", (Throwable)e);
        }
    }

    public void pin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void pin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public List<Object> get(String queryKey) {
        try {
            return (List)this.client.get(this.keyPrefix + queryKey);
        }
        catch (Exception e) {
            throw new NucleusException("Exception thrown in retrieval from xmemcached", (Throwable)e);
        }
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty() method not supported by spymemcached plugin");
    }

    public synchronized List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        try {
            this.client.set(this.keyPrefix + queryKey, this.expireSeconds, results);
        }
        catch (Exception e) {
            throw new NucleusException("Exception thrown in persistence to xmemcached", (Throwable)e);
        }
        return results;
    }

    public int size() {
        throw new UnsupportedOperationException("size() method not supported by spymemcached plugin");
    }
}

